/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator.tcp;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.communicator.TcpClient;
import org.rockhopper.smarthome.wes.jwes.communicator.tcp.FIFOEntry;
import org.rockhopper.smarthome.wes.jwes.communicator.tcp.TcpProtocol;
import org.rockhopper.smarthome.wes.jwes.model.WesEvent;
import org.rockhopper.smarthome.wes.jwes.model.WesEventListener;
import org.rockhopper.smarthome.wes.jwes.model.data.WesData;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCard;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;
import org.rockhopper.smarthome.wes.jwes.model.data.type.FieldCommand;
import org.rockhopper.smarthome.wes.jwes.model.helper.WesPrioritiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpPolling {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private ScheduledExecutorService executor;
    private PriorityBlockingQueue<FIFOEntry<?, ?>> fieldsToUpdate;
    public static final int DELAY = 500;
    private WesEventListener eventListener;
    private TcpClient tcpClient = null;
    private TcpProtocol tcpProtocol = null;
    private WesData wesData;
    private static Pattern RELAYSCARD_STATES_PATTERN_EXPR;
    private static Pattern RELAYSCARD_RELAY_STATE_PATTERN_EXPR;

    public TcpPolling(String wesDeviceIp, int wesTcpPort, WesData wesData) {
        this.wesData = wesData;
        this.tcpClient = new TcpClient(wesDeviceIp, wesTcpPort);
    }

    public void run() {
        if (this.tcpClient == null) {
            throw new IllegalArgumentException("TcpPolling requires a TcpClient!");
        }
        if (this.eventListener == null) {
            this.eventListener = new WesEventListener(this){};
        }
        this.executor = Executors.newScheduledThreadPool(10);
        this.fieldsToUpdate = new PriorityBlockingQueue(50);
        this.tcpProtocol = new TcpProtocol(this.wesData);
        WesPrioritiesHelper wesPrioritiesHelper = new WesPrioritiesHelper(Field.PRIORITY_REALTIME);
        Map<Field<?, ?>, Byte> fieldsPrioritiesMap = wesPrioritiesHelper.browse(this.wesData);
        this.populateFieldsToUpdate(fieldsPrioritiesMap);
        while (!this.executor.isShutdown()) {
            FIFOEntry<?, ?> fieldToUpdate = null;
            try {
                fieldToUpdate = this.fieldsToUpdate.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (fieldToUpdate == null) continue;
            this.update(fieldToUpdate.getEntry());
        }
    }

    public void halt() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void populateFieldsToUpdate(Map<Field<?, ?>, Byte> fieldsPrioritiesMap) {
        if (fieldsPrioritiesMap != null) {
            for (Map.Entry<Field<?, ?>, Byte> entry : fieldsPrioritiesMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || entry.getKey().getPriority() < 0) continue;
                this.addFieldToUpdate(entry.getKey());
            }
        }
    }

    private <V, W> void addFieldToUpdate(Field<V, W> field) {
        this.addFieldToUpdate(new FieldCommand<Object, W>(field, null));
    }

    private <V, W> void addFieldToUpdate(FieldCommand<V, W> field) {
        if (field != null) {
            this.fieldsToUpdate.add(new FIFOEntry<V, W>(field));
        }
    }

    private <V, W> void update(final FieldCommand<V, W> fieldToUpdate) {
        if (fieldToUpdate.getPriority() != null) {
            String command;
            String response = null;
            if (this.tcpProtocol != null && (command = this.tcpProtocol.getWesCommand(fieldToUpdate)) != null) {
                response = this.tcpClient.call(command);
            }
            if (response != null) {
                V oldValue = fieldToUpdate.getValue();
                this.tcpProtocol.updateField(fieldToUpdate, response);
                if (!(fieldToUpdate.getValue() == oldValue || oldValue != null && fieldToUpdate.getValue() != null && oldValue.equals(fieldToUpdate.getValue()))) {
                    this.eventListener.onEvent(new WesEvent(fieldToUpdate.getField().getLabel(), WesEvent.WesEventCode.UPDATE, oldValue, fieldToUpdate.getValue()));
                    Matcher matcherStates = RELAYSCARD_STATES_PATTERN_EXPR.matcher(fieldToUpdate.getField().getLabel());
                    Matcher matcherState = RELAYSCARD_RELAY_STATE_PATTERN_EXPR.matcher(fieldToUpdate.getField().getLabel());
                    if (matcherStates.find()) {
                        System.out.println("------------ Y" + fieldToUpdate.getField().getLabel() + "->" + matcherStates.group(1));
                        String relayStatePrefix = StringUtils.removeEnd((String)fieldToUpdate.getField().getLabel(), (String)"states") + "relay";
                        String states = (String)fieldToUpdate.getValue();
                        String relayCardNb = matcherStates.group(1);
                        byte iRelayCardNb = Byte.valueOf(relayCardNb);
                        WesRelaysCard relaysCard = this.wesData.getRelaysCards().getCards().get(iRelayCardNb);
                        for (byte i = 0; i < 8; i = (byte)(i + 1)) {
                            String currentRelayStateLabel = relayStatePrefix + i + ".state";
                            Boolean currentState = relaysCard.getState(i);
                            if (states.charAt(i) == '0') {
                                this.eventListener.onEvent(new WesEvent(currentRelayStateLabel, WesEvent.WesEventCode.UPDATE, currentState, Boolean.FALSE));
                                continue;
                            }
                            if (states.charAt(i) != '1') continue;
                            this.eventListener.onEvent(new WesEvent(currentRelayStateLabel, WesEvent.WesEventCode.UPDATE, currentState, Boolean.TRUE));
                        }
                    } else if (matcherState.find()) {
                        this.log.info("Card#{} Relay{} update is triggering Card#{}.states refresh! ({}->{})", new Object[]{matcherState.group(1), matcherState.group(2), matcherState.group(1), oldValue, fieldToUpdate.getValue()});
                        String relayCardNb = matcherState.group(1);
                        byte iRelayCardNb = Byte.valueOf(relayCardNb);
                        String currentStates = this.wesData.getRelaysCards().getCards().get(iRelayCardNb).getStates().getValue();
                        this.eventListener.onEvent(new WesEvent(this.wesData.getRelaysCards().getCards().get(iRelayCardNb).getStates().getLabel(), WesEvent.WesEventCode.SYNC, currentStates, currentStates));
                    } else {
                        System.out.println("------------ N" + fieldToUpdate.getField().getLabel());
                        this.eventListener.onEvent(new WesEvent(fieldToUpdate.getField().getLabel(), WesEvent.WesEventCode.UPDATE, oldValue, fieldToUpdate.getValue()));
                    }
                }
            }
            if (fieldToUpdate.getNewValue() == null && !this.executor.isShutdown()) {
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        TcpPolling.this.fieldsToUpdate.add(new FIFOEntry(fieldToUpdate));
                    }
                }, (long)(fieldToUpdate.getPriority() * 500), TimeUnit.MILLISECONDS);
            }
        }
    }

    public <V, W> void forceUpdate(Field<V, W> field, V newValue) {
        this.addFieldToUpdate(new FieldCommand<V, W>(field, newValue));
    }

    public void setEventListener(WesEventListener eventListener) {
        this.eventListener = eventListener;
    }

    static {
        String pattern = StringUtils.replace((String)".relaysCards.card%s.states", (String)"%s", (String)"([^\\\\d]+)");
        System.out.println("RELAYSCARD_STATES_PATTERN_EXPR: " + pattern);
        RELAYSCARD_STATES_PATTERN_EXPR = Pattern.compile(pattern);
        pattern = ".relaysCards.card([^\\\\d]+).relay([^\\\\d]+).state";
        System.out.println("RELAYSCARD_STATES_PATTERN_EXPR: " + pattern);
        RELAYSCARD_RELAY_STATE_PATTERN_EXPR = Pattern.compile(pattern);
    }
}

