/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator.tcp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.model.data.TeleInfo;
import org.rockhopper.smarthome.wes.jwes.model.data.WesData;
import org.rockhopper.smarthome.wes.jwes.model.data.WesOneWireRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesPulseCounter;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCard;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCards;
import org.rockhopper.smarthome.wes.jwes.model.data.WesSensor;
import org.rockhopper.smarthome.wes.jwes.model.data.type.FieldCommand;

public class TcpProtocol {
    private static Map<String, String> commands;
    private static Map<String, Function<String, ?>> responses;

    public TcpProtocol() {
        this(null);
    }

    public TcpProtocol(WesData wesData) {
        if (wesData == null) {
            this.init(new WesData());
        } else {
            this.init(wesData);
        }
    }

    private void init(WesData wesData) {
        WesRelaysCards relaysCards;
        if (wesData == null) {
            throw new UnsupportedOperationException("You must provide an instance of WesData");
        }
        HashMap<String, String> _commands = new HashMap<String, String>();
        HashMap<String, Function<String, Object>> _responses = new HashMap<String, Function<String, Object>>();
        TeleInfoTcpProtocol teleInfoTcpProtocol = new TeleInfoTcpProtocol(_commands, _responses);
        teleInfoTcpProtocol.initTic(wesData.getTic1());
        teleInfoTcpProtocol.initTic(wesData.getTic2());
        teleInfoTcpProtocol.initTic(wesData.getTic3());
        WesRelayTcpProtocol wesRelayTcpProtocol = new WesRelayTcpProtocol(_commands, _responses);
        wesRelayTcpProtocol.initWesRelay(wesData.getRelay1());
        wesRelayTcpProtocol.initWesRelay(wesData.getRelay2());
        if (wesData.getPulseCounters() != null) {
            WesPulseCounterTcpProtocol wesPulseCounterTcpProtocol = new WesPulseCounterTcpProtocol(_commands, _responses);
            for (int i = 0; i <= 3; i = (int)((byte)(i + 1))) {
                wesPulseCounterTcpProtocol.initPulseCounter(wesData.getPulseCounters().get(i));
            }
        }
        if (wesData.getSensors() != null) {
            WesSensorTcpProtocol wesSensorTcpProtocol = new WesSensorTcpProtocol(_commands, _responses);
            for (WesSensor sensor : wesData.getSensors()) {
                wesSensorTcpProtocol.initSensor(sensor);
            }
        }
        if ((relaysCards = wesData.getRelaysCards()) != null) {
            WesRelaysCardTcpProtocol wesRelaysCardTcpProtocol = new WesRelaysCardTcpProtocol(_commands, _responses);
            if (relaysCards.getCards() != null) {
                for (WesRelaysCard card : relaysCards.getCards()) {
                    wesRelaysCardTcpProtocol.initWesRelaysCard(card);
                }
            }
        }
        commands = Collections.unmodifiableMap(_commands);
        responses = Collections.unmodifiableMap(_responses);
    }

    public String getWesCommand(FieldCommand<?, ?> fieldCommand) {
        if (fieldCommand != null && fieldCommand.getField().getLabel() != null) {
            if (fieldCommand.getNewValue() != null) {
                String cmd = commands.get(fieldCommand.getField().getLabel() + "_W");
                Object param = fieldCommand.getNewValue();
                if (param instanceof Boolean) {
                    param = (Boolean)param != false ? (byte)1 : 0;
                }
                return cmd != null ? String.format(cmd, param) : null;
            }
            return commands.get(fieldCommand.getField().getLabel());
        }
        return null;
    }

    public <T> T processResponse(FieldCommand<?, ?> fieldCommand, String response) {
        Function<String, ?> responseHandler = null;
        if (fieldCommand != null && fieldCommand.getField().getLabel() != null) {
            responseHandler = fieldCommand.getNewValue() != null ? responses.get(fieldCommand.getField().getLabel() + "_W") : responses.get(fieldCommand.getField().getLabel());
            if (responseHandler == null) {
                System.out.println("Don't know how to handle response for label '" + fieldCommand.getField().getLabel() + "'");
            } else {
                return (T)responseHandler.apply(response);
            }
        }
        return null;
    }

    public <T> void updateField(FieldCommand<T, ?> fieldCommand, String response) {
        if (fieldCommand != null) {
            fieldCommand.getField().setValue(this.processResponse(fieldCommand, response));
        }
    }

    private static class TeleInfoTcpProtocol {
        private Map<String, String> _commands;
        private Map<String, Function<String, Object>> _responses;
        protected String WES_DATA_TELEINFO_INDEXN_CMD = "gT%1d%2d";
        protected String WES_DATA_TELEINFO_IINSTN_CMD = "gT%1d0%1d";
        protected String WES_DATA_TELEINFO_PAPPS_CMD = "gT%1d00";
        protected byte WES_DATA_TELEINFO_INDEX0 = (byte)10;
        protected byte WES_DATA_TELEINFO_INDEX1 = (byte)11;
        protected byte WES_DATA_TELEINFO_INDEX2 = (byte)12;
        protected byte WES_DATA_TELEINFO_INDEX3 = (byte)13;
        protected byte WES_DATA_TELEINFO_INDEX4 = (byte)14;
        protected byte WES_DATA_TELEINFO_INDEX5 = (byte)15;

        public TeleInfoTcpProtocol(Map<String, String> _commands, Map<String, Function<String, Object>> _responses) {
            this._commands = _commands;
            this._responses = _responses;
        }

        public void initTic(TeleInfo teleinfo) {
            if (teleinfo == null) {
                return;
            }
            if (teleinfo.getIndex1() != null) {
                this._commands.put(teleinfo.getIndex1().getLabel(), this.getCommandByIndexAndIndexType(this.WES_DATA_TELEINFO_INDEXN_CMD, teleinfo.getIndex(), this.WES_DATA_TELEINFO_INDEX0));
                this._responses.put(teleinfo.getIndex1().getLabel(), new BigDecimalFormatResponseHandler(new BigDecimal(1000), 3));
            }
            if (teleinfo.getIinstMono() != null) {
                this._commands.put(teleinfo.getIinstMono().getLabel(), this.getCommandByIndexAndPhaseNb(this.WES_DATA_TELEINFO_IINSTN_CMD, teleinfo.getIndex(), (byte)1));
                this._responses.put(teleinfo.getIinstMono().getLabel(), new DummyResponseHandler());
            }
            if (teleinfo.getpApps() != null) {
                this._commands.put(teleinfo.getpApps().getLabel(), this.getCommandByIndex(this.WES_DATA_TELEINFO_PAPPS_CMD, teleinfo.getIndex()));
                this._responses.put(teleinfo.getpApps().getLabel(), new StringFormatResponseHandler("(%s,0,0)"));
            }
        }

        private String getCommandByIndex(String parametrizedCommand, byte index) {
            return String.format(parametrizedCommand, index);
        }

        private String getCommandByIndexAndPhaseNb(String parametrizedCommand, byte index, byte n) {
            return String.format(parametrizedCommand, index, n);
        }

        private String getCommandByIndexAndIndexType(String parametrizedCommand, byte index, byte indexType) {
            return String.format(parametrizedCommand, index, indexType);
        }
    }

    private static class WesRelayTcpProtocol {
        private Map<String, String> _commands;
        private Map<String, Function<String, Object>> _responses;
        protected String WES_DATA_RELAY_VALUE_CMD = "gr00%1d";
        protected String WES_DATA_RELAY_VALUE_CMD_W = "srl%1d=%%d";

        public WesRelayTcpProtocol(Map<String, String> _commands, Map<String, Function<String, Object>> _responses) {
            this._commands = _commands;
            this._responses = _responses;
        }

        public void initWesRelay(WesRelay relay) {
            if (relay == null) {
                return;
            }
            if (relay.getValue() != null) {
                this._commands.put(relay.getValue().getLabel(), this.getCommandByIndex(this.WES_DATA_RELAY_VALUE_CMD, relay.getIndex()));
                this._responses.put(relay.getValue().getLabel(), new DummyResponseHandler());
                this._commands.put(relay.getValue().getLabel() + "_W", this.getCommandByIndex(this.WES_DATA_RELAY_VALUE_CMD_W, relay.getIndex()));
                this._responses.put(relay.getValue().getLabel() + "_W", new SetRelayResponseHandler(this, relay.getIndex()));
            }
        }

        private String getCommandByIndex(String parametrizedCommand, byte index) {
            return String.format(parametrizedCommand, index);
        }

        public class SetRelayResponseHandler
        implements Function<String, Object> {
            private byte index;

            public SetRelayResponseHandler(WesRelayTcpProtocol this$0, byte index) {
                this.index = index;
            }

            @Override
            public Object apply(String response) throws UnsupportedOperationException {
                String responsePrefix = "RLMB=";
                int prefixLength = responsePrefix.length();
                char c = '?';
                if (response != null && response.length() == prefixLength + 2 && response.startsWith(responsePrefix)) {
                    c = response.charAt(prefixLength + this.index - 1);
                }
                System.out.println(response + " for " + this.index + ";c=" + c);
                if (c == '1') {
                    return Boolean.TRUE;
                }
                if (c == '0') {
                    return Boolean.FALSE;
                }
                return null;
            }
        }
    }

    private static class WesPulseCounterTcpProtocol {
        private Map<String, String> _commands;
        private Map<String, Function<String, Object>> _responses;
        protected String WES_DATA_PULSECOUNTER_GENERIC_CMD = "gP%s0%s";
        protected char WES_DATA_PULSECOUNTER_DEBIT_SUFFIX = (char)48;
        protected char WES_DATA_PULSECOUNTER_INDEX_SUFFIX = (char)49;
        protected char WES_DATA_PULSECOUNTER_TODAYCONSUMPTION_SUFFIX = (char)50;
        protected char WES_DATA_PULSECOUNTER_MONTHCONSUMPTION_SUFFIX = (char)51;
        protected char WES_DATA_PULSECOUNTER_YEARCONSUMPTION_SUFFIX = (char)52;
        protected char WES_DATA_PULSECOUNTER_YESTERDAYCONSUMPTION_SUFFIX = (char)50;

        public WesPulseCounterTcpProtocol(Map<String, String> _commands, Map<String, Function<String, Object>> _responses) {
            this._commands = _commands;
            this._responses = _responses;
        }

        public void initPulseCounter(WesPulseCounter pulseCounter) {
            if (pulseCounter == null) {
                return;
            }
            if (pulseCounter.getDebit() != null) {
                this._commands.put(pulseCounter.getDebit().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_GENERIC_CMD, (byte)(pulseCounter.getIndex() + 1), this.WES_DATA_PULSECOUNTER_DEBIT_SUFFIX));
                this._responses.put(pulseCounter.getDebit().getLabel(), new DummyResponseHandler());
            }
            if (pulseCounter.getCurrentIndex() != null) {
                this._commands.put(pulseCounter.getCurrentIndex().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_GENERIC_CMD, (byte)(pulseCounter.getIndex() + 1), this.WES_DATA_PULSECOUNTER_INDEX_SUFFIX));
                this._responses.put(pulseCounter.getCurrentIndex().getLabel(), new DummyResponseHandler());
            }
            CombinedResponseHandler removeUnitAndRoundResponseHandler = new CombinedResponseHandler(new RemoveUnitResponseHandler(), new BigIntegerRoundResponseHandler());
            if (pulseCounter.getTodayConsumption() != null) {
                this._commands.put(pulseCounter.getTodayConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_GENERIC_CMD, (byte)(pulseCounter.getIndex() + 1), this.WES_DATA_PULSECOUNTER_TODAYCONSUMPTION_SUFFIX));
                this._responses.put(pulseCounter.getTodayConsumption().getLabel(), removeUnitAndRoundResponseHandler);
            }
            if (pulseCounter.getMonthConsumption() != null) {
                this._commands.put(pulseCounter.getMonthConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_GENERIC_CMD, (byte)(pulseCounter.getIndex() + 1), this.WES_DATA_PULSECOUNTER_MONTHCONSUMPTION_SUFFIX));
                this._responses.put(pulseCounter.getMonthConsumption().getLabel(), removeUnitAndRoundResponseHandler);
            }
            if (pulseCounter.getYearConsumption() != null) {
                this._commands.put(pulseCounter.getYearConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_GENERIC_CMD, (byte)(pulseCounter.getIndex() + 1), this.WES_DATA_PULSECOUNTER_YEARCONSUMPTION_SUFFIX));
                this._responses.put(pulseCounter.getYearConsumption().getLabel(), removeUnitAndRoundResponseHandler);
            }
            if (pulseCounter.getYesterdayConsumption() != null) {
                this._commands.put(pulseCounter.getYesterdayConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_GENERIC_CMD, (byte)(pulseCounter.getIndex() + 1), this.WES_DATA_PULSECOUNTER_YESTERDAYCONSUMPTION_SUFFIX));
                this._responses.put(pulseCounter.getYesterdayConsumption().getLabel(), removeUnitAndRoundResponseHandler);
            }
        }

        private char[] getIndexAsChars(byte index) {
            String formattedIdx = StringUtils.leftPad((String)String.valueOf(index), (int)1, (char)'0');
            return formattedIdx.toCharArray();
        }

        private String getCommandByIndexAsChars(String parametrizedCommand, byte index, char commandSuffix) {
            char[] indexAsChars = this.getIndexAsChars(index);
            return String.format(parametrizedCommand, Character.valueOf(indexAsChars[0]), Character.valueOf(commandSuffix));
        }
    }

    private static class WesSensorTcpProtocol {
        private Map<String, String> _commands;
        private Map<String, Function<String, Object>> _responses;
        protected String WES_DATA_SENSOR_VALUE_CMD = "gW0%s%s";

        public WesSensorTcpProtocol(Map<String, String> _commands, Map<String, Function<String, Object>> _responses) {
            this._commands = _commands;
            this._responses = _responses;
        }

        public void initSensor(WesSensor sensor) {
            if (sensor == null) {
                return;
            }
            if (sensor.getValue() != null) {
                this._commands.put(sensor.getValue().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_SENSOR_VALUE_CMD, (byte)(sensor.getIndex() + 1)));
                this._responses.put(sensor.getValue().getLabel(), new DummyResponseHandler());
            }
        }

        private char[] getIndexAsChars(byte index) {
            String formattedId = StringUtils.leftPad((String)String.valueOf(index), (int)2, (char)'0');
            return formattedId.toCharArray();
        }

        private String getCommandByIndexAsChars(String parametrizedCommand, byte index) {
            char[] indexAsChars = this.getIndexAsChars(index);
            return String.format(parametrizedCommand, Character.valueOf(indexAsChars[0]), Character.valueOf(indexAsChars[1]));
        }
    }

    private class WesRelaysCardTcpProtocol {
        private Map<String, String> _commands;
        private Map<String, Function<String, Object>> _responses;
        protected String WES_DATA_RELAYSCARD_STATES_CMD = "gr%1d09";

        public WesRelaysCardTcpProtocol(Map<String, String> _commands, Map<String, Function<String, Object>> _responses) {
            this._commands = _commands;
            this._responses = _responses;
        }

        public void initWesRelaysCard(WesRelaysCard wesRelaysCard) {
            if (wesRelaysCard == null) {
                return;
            }
            List<WesOneWireRelay> wesOneWireRelays = wesRelaysCard.getRelays();
            if (wesOneWireRelays != null) {
                WesOneWireRelayTcpProtocol oneWireRelayXmlProtocol = new WesOneWireRelayTcpProtocol(TcpProtocol.this, this._commands, this._responses);
                for (WesOneWireRelay oneWirerelay : wesOneWireRelays) {
                    oneWireRelayXmlProtocol.initWesOneWireRelay(oneWirerelay);
                }
            }
            this._commands.put(wesRelaysCard.getLabel(), this.getCommandByIndex(this.WES_DATA_RELAYSCARD_STATES_CMD, (byte)(wesRelaysCard.getIndex() + 1)));
            this._responses.put(wesRelaysCard.getLabel(), new DummyResponseHandler());
        }

        private String getCommandByIndex(String parametrizedCommand, byte index) {
            return String.format(parametrizedCommand, index);
        }
    }

    private class WesOneWireRelayTcpProtocol {
        private Map<String, String> _commands;
        private Map<String, Function<String, Object>> _responses;
        protected String WES_DATA_RELAY_STATE_CMD_W = "srl%d%02d=%%d";

        public WesOneWireRelayTcpProtocol(TcpProtocol tcpProtocol, Map<String, String> _commands, Map<String, Function<String, Object>> _responses) {
            this._commands = _commands;
            this._responses = _responses;
        }

        public void initWesOneWireRelay(WesOneWireRelay relay) {
            if (relay == null) {
                return;
            }
            if (relay.getState() != null) {
                this._commands.put(relay.getState().getLabel() + "_W", this.getCommandByCardIndexAndIndex(this.WES_DATA_RELAY_STATE_CMD_W, (byte)(relay.getCardIndex() + 1), relay.getIndex()));
                this._responses.put(relay.getState().getLabel() + "_W", new SetOneWireRelayResponseHandler(this, relay.getCardIndex(), relay.getIndex()));
            }
        }

        private String getCommandByCardIndexAndIndex(String parametrizedCommand, byte cardIndex, byte index) {
            return String.format(parametrizedCommand, cardIndex, index);
        }

        public class SetOneWireRelayResponseHandler
        implements Function<String, Object> {
            private byte cardIndex;
            private byte index;

            public SetOneWireRelayResponseHandler(WesOneWireRelayTcpProtocol this$1, byte cardIndex, byte index) {
                this.cardIndex = cardIndex;
                this.index = index;
            }

            @Override
            public Object apply(String response) throws UnsupportedOperationException {
                String responsePrefix = "RLW%01d=";
                int prefixLength = "RLWx=".length();
                char c = '?';
                if (response != null && response.length() == prefixLength + 8 && response.startsWith(String.format(responsePrefix, this.cardIndex))) {
                    c = response.charAt(prefixLength + this.index - 1);
                }
                System.out.println(response + " for " + this.cardIndex + "/" + this.index + ";c=" + c);
                if (c == '1') {
                    return Boolean.TRUE;
                }
                if (c == '0') {
                    return Boolean.FALSE;
                }
                return null;
            }
        }
    }

    static class BigDecimalFormatResponseHandler
    extends DummyResponseHandler {
        private BigDecimal divideBy;
        private Integer scale;
        private RoundingMode roundingMode;

        public BigDecimalFormatResponseHandler() {
            this(null, null);
        }

        public BigDecimalFormatResponseHandler(BigDecimal divideBy, Integer scale) {
            this(divideBy, scale, RoundingMode.UNNECESSARY);
        }

        public BigDecimalFormatResponseHandler(BigDecimal divideBy, Integer scale, RoundingMode roundingMode) {
            this.divideBy = divideBy;
            this.scale = scale;
            this.roundingMode = roundingMode;
        }

        @Override
        public Object apply(String response) {
            if (response == null) {
                return null;
            }
            BigDecimal value = new BigDecimal(response);
            if (this.divideBy != null && this.scale != null) {
                value = value.divide(this.divideBy, (int)this.scale, this.roundingMode);
            }
            return super.apply(value.toString());
        }
    }

    static class CombinedResponseHandler
    extends DummyResponseHandler {
        private DummyResponseHandler handler1;
        private DummyResponseHandler handler2;

        public CombinedResponseHandler(DummyResponseHandler handler1, DummyResponseHandler handler2) {
            this.handler1 = handler1;
            this.handler2 = handler2;
        }

        @Override
        public Object apply(String response) {
            return super.apply(this.handler2.apply(this.handler1.apply(response).toString()).toString());
        }
    }

    static class BigIntegerRoundResponseHandler
    extends DummyResponseHandler {
        BigIntegerRoundResponseHandler() {
        }

        @Override
        public Object apply(String response) {
            if (response == null) {
                return null;
            }
            return BigDecimal.valueOf(Double.parseDouble(response));
        }
    }

    static class RemoveUnitResponseHandler
    extends DummyResponseHandler {
        RemoveUnitResponseHandler() {
        }

        @Override
        public Object apply(String response) {
            if (response == null) {
                return null;
            }
            int firstSpaceIndex = response.indexOf(32);
            if (firstSpaceIndex > -1) {
                response = response.substring(0, firstSpaceIndex);
            }
            return super.apply(response);
        }
    }

    static class StringFormatResponseHandler
    extends DummyResponseHandler {
        private String pattern;

        public StringFormatResponseHandler(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public Object apply(String response) {
            if (response == null) {
                return null;
            }
            if (this.pattern == null) {
                return null;
            }
            return super.apply(String.format(this.pattern, response));
        }
    }

    static class DummyResponseHandler
    implements Function<String, Object> {
        DummyResponseHandler() {
        }

        @Override
        public Object apply(String response) {
            return response;
        }
    }
}

