/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.communicator.xml.XmlProtocol;
import org.rockhopper.smarthome.wes.jwes.model.data.type.BSSW;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;

public class FieldConverter
implements Converter {
    protected XmlProtocol xmlProtocol;
    protected boolean withFormat;

    public FieldConverter(XmlProtocol xmlProtocol, boolean withFormat) {
        this.xmlProtocol = xmlProtocol;
        this.withFormat = withFormat;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Field.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Field field = (Field)source;
        if (field != null) {
            String command;
            if (this.xmlProtocol != null && (command = this.xmlProtocol.getWesCommand(field)) != null) {
                writer.addAttribute("command", command);
            }
            if (field.getType() != null && !field.getType().equals(String.class)) {
                writer.addAttribute("type", field.getType().getSimpleName());
            }
            if (field.getSubType() != null) {
                writer.addAttribute("subType", field.getSubType().getSimpleName());
            }
            if (field.getPriority() != null) {
                writer.addAttribute("priority", field.getPriority().toString());
            }
            if (this.withFormat) {
                String format;
                if (this.xmlProtocol != null && (format = this.xmlProtocol.getWesFormat(field)) != null) {
                    writer.setValue(format);
                }
            } else if (field.getValue() != null) {
                BSSW bsswValue;
                if (field.getType() == null || field.getType().equals(String.class)) {
                    writer.setValue(field.getValue().toString());
                } else if (field.getType().equals(Boolean.class)) {
                    writer.setValue(((Boolean)field.getValue()).toString());
                } else if (field.getType().equals(Byte.class)) {
                    writer.setValue(((Byte)field.getValue()).toString());
                } else if (field.getType().equals(BigDecimal.class)) {
                    writer.setValue(new DecimalFormat("#,###.##", new DecimalFormatSymbols(Locale.ENGLISH)).format(field.getValue()));
                } else if (field.getType().equals(BigInteger.class)) {
                    writer.setValue(field.getValue().toString());
                } else if (field.getType().equals(BSSW.class) && (bsswValue = (BSSW)field.getValue()).size() > 0) {
                    Set bsswValueEntries = bsswValue.entrySet();
                    for (Map.Entry entry : bsswValueEntries) {
                        String id = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (id == null || value == null) continue;
                        writer.startNode("bssw");
                        writer.startNode("id");
                        writer.setValue(id);
                        writer.endNode();
                        writer.startNode("value");
                        if (field.getSubType() == null || field.getSubType().equals(String.class) || field.getSubType().equals(Byte.class)) {
                            writer.setValue(value.toString());
                        } else if (field.getSubType().equals(Boolean.class)) {
                            writer.setValue(((Boolean)value).toString());
                        }
                        writer.endNode();
                        writer.endNode();
                    }
                }
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String type = reader.getAttribute("type");
        String subType = reader.getAttribute("subType");
        String priority = reader.getAttribute("priority");
        String valueOrFormat = reader.getValue();
        Field<Object, Object> toReturn = null;
        Byte bytePriority = null;
        if (priority != null) {
            bytePriority = Byte.valueOf(priority);
        }
        if (type == null || type.equalsIgnoreCase(String.class.getSimpleName())) {
            Field field = new Field(String.class, bytePriority);
            if (!this.withFormat) {
                field.setValue(valueOrFormat);
            }
            toReturn = field;
        } else if (type.equalsIgnoreCase(Byte.class.getSimpleName())) {
            Field field = new Field(Byte.class, bytePriority);
            if (!this.withFormat && valueOrFormat.length() > 0) {
                field.setValue(Byte.valueOf(valueOrFormat));
            }
            toReturn = field;
        } else if (type.equalsIgnoreCase(Boolean.class.getSimpleName())) {
            Field field = new Field(Boolean.class, bytePriority);
            if (!this.withFormat && valueOrFormat.length() > 0) {
                field.setValue(Boolean.valueOf(valueOrFormat));
            }
            toReturn = field;
        } else if (type.equalsIgnoreCase(BigDecimal.class.getSimpleName())) {
            Field field = new Field(BigDecimal.class, bytePriority);
            if (!this.withFormat && valueOrFormat.length() > 0) {
                try {
                    DecimalFormat df = new DecimalFormat("#,###.##", new DecimalFormatSymbols(Locale.ENGLISH));
                    df.setParseBigDecimal(true);
                    df.parse(valueOrFormat);
                    field.setValue((BigDecimal)df.parse(valueOrFormat));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Fail parsing BigDecimal value '" + valueOrFormat + "' with US Locale(\"#,###.##\")");
                }
            }
            toReturn = field;
        } else if (type.equalsIgnoreCase(BigInteger.class.getSimpleName())) {
            Field field = new Field(BigInteger.class, bytePriority);
            if (!this.withFormat && valueOrFormat.length() > 0 && StringUtils.isNumeric((String)valueOrFormat)) {
                try {
                    field.setValue(new BigInteger(valueOrFormat));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Fail parsing BigInteger value '" + valueOrFormat + "'");
                }
            }
            toReturn = field;
        } else if (type.equalsIgnoreCase(BSSW.class.getSimpleName())) {
            Field<BSSW, Object> field = null;
            if (subType == null || subType.equals(String.class.getSimpleName())) {
                field = new Field<BSSW, String>(BSSW.class, String.class, bytePriority);
            } else if (subType.equals(Boolean.class.getSimpleName())) {
                field = new Field<BSSW, Boolean>(BSSW.class, Boolean.class, bytePriority);
            } else if (subType.equals(Byte.class.getSimpleName())) {
                field = new Field<BSSW, Byte>(BSSW.class, Byte.class, bytePriority);
            }
            if (field != null) {
                field.setValue(new BSSW());
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("bssw".equals(reader.getNodeName())) {
                        String id = null;
                        Object value = null;
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("id".equals(reader.getNodeName())) {
                                id = reader.getValue();
                            }
                            if ("value".equals(reader.getNodeName())) {
                                String sValue = reader.getValue();
                                if (subType == null || subType.equals(String.class.getSimpleName())) {
                                    value = sValue;
                                } else if (subType.equals(Boolean.class.getSimpleName())) {
                                    value = Boolean.valueOf(sValue);
                                } else if (subType.equals(Byte.class.getSimpleName())) {
                                    value = Byte.valueOf(sValue);
                                }
                            }
                            reader.moveUp();
                        }
                        if (id != null && value != null) {
                            field.getValue().put(id, value);
                        }
                    }
                    reader.moveUp();
                }
            }
            toReturn = field;
        }
        return toReturn;
    }
}

