/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import org.rockhopper.smarthome.wes.jwes.communicator.xml.FieldConverter;
import org.rockhopper.smarthome.wes.jwes.communicator.xml.XmlProtocol;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCards;
import org.rockhopper.smarthome.wes.jwes.model.data.type.BSSW;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;

public class WesRelaysCardsConverter
implements Converter {
    protected XmlProtocol xmlProtocol;
    protected boolean withFormat;
    private FieldConverter fieldConverter;
    private CollectionConverter listConverter;

    public WesRelaysCardsConverter(Mapper mapper, XmlProtocol xmlProtocol, boolean withFormat) {
        this.xmlProtocol = xmlProtocol;
        this.withFormat = withFormat;
        this.fieldConverter = new FieldConverter(xmlProtocol, withFormat);
        this.listConverter = new CollectionConverter(mapper);
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(WesRelaysCards.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        WesRelaysCards wesRelaysCards = (WesRelaysCards)source;
        if (wesRelaysCards != null) {
            writer.startNode("cards");
            if (wesRelaysCards.getCards() != null) {
                this.listConverter.marshal(wesRelaysCards.getCards(), writer, context);
            }
            writer.endNode();
            writer.startNode("states");
            Field<BSSW, Byte> states = wesRelaysCards.getStates();
            if (states != null) {
                this.fieldConverter.marshal(states, writer, context);
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        ArrayList wesRelaysCardList = new ArrayList();
        wesRelaysCardList = (ArrayList)context.convertAnother(wesRelaysCardList, ArrayList.class);
        reader.moveUp();
        reader.moveDown();
        Field states = new Field(BSSW.class, Byte.class, Field.PRIORITY_DISCOVERY);
        states = (Field)context.convertAnother(states, Field.class);
        reader.moveUp();
        WesRelaysCards toReturn = new WesRelaysCards((byte)(wesRelaysCardList.size() - 1));
        toReturn.setCards(wesRelaysCardList);
        toReturn.setStates(states);
        return toReturn;
    }
}

