/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.WstxDriver;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.communicator.xml.FieldConverter;
import org.rockhopper.smarthome.wes.jwes.communicator.xml.WesRelaysCardsConverter;
import org.rockhopper.smarthome.wes.jwes.communicator.xml.XmlProtocol;
import org.rockhopper.smarthome.wes.jwes.model.data.WesData;
import org.rockhopper.smarthome.wes.jwes.model.data.WesSensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlHandler {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private XmlProtocol xmlProtocol;
    private XStream xStreamWithFormat;
    private XStream xStreamWithoutFormat;
    private WesData wesData;

    public XmlHandler(WesData wesData) {
        this.wesData = wesData;
        this.xmlProtocol = new XmlProtocol(wesData);
    }

    protected XStream getXStreamWithFormat() {
        if (this.xStreamWithFormat == null) {
            this.xStreamWithFormat = new XStream((HierarchicalStreamDriver)new WstxDriver());
            Class[] annotatedClasses = new Class[]{WesData.class, WesSensor.class};
            this.xStreamWithFormat.processAnnotations(annotatedClasses);
            this.xStreamWithFormat.registerConverter((Converter)new WesRelaysCardsConverter(this.xStreamWithFormat.getMapper(), this.xmlProtocol, true));
            this.xStreamWithFormat.registerConverter((Converter)new FieldConverter(this.xmlProtocol, true));
            this.xStreamWithFormat.allowTypesByWildcard(new String[]{"org.rockhopper.smarthome.wes.jwes.**"});
        }
        return this.xStreamWithFormat;
    }

    protected XStream getXStreamWithoutFormat() {
        if (this.xStreamWithoutFormat == null) {
            this.xStreamWithoutFormat = new XStream((HierarchicalStreamDriver)new WstxDriver());
            Class[] annotatedClasses = new Class[]{WesData.class, WesSensor.class};
            this.xStreamWithoutFormat.processAnnotations(annotatedClasses);
            this.xStreamWithoutFormat.registerConverter((Converter)new WesRelaysCardsConverter(this.xStreamWithoutFormat.getMapper(), this.xmlProtocol, false));
            this.xStreamWithoutFormat.registerConverter((Converter)new FieldConverter(this.xmlProtocol, false));
            this.xStreamWithoutFormat.allowTypesByWildcard(new String[]{"org.rockhopper.smarthome.wes.jwes.**"});
        }
        return this.xStreamWithoutFormat;
    }

    public Object deserialize(String xml) {
        this.log.debug("Deserialize: \n{}\n\n", (Object)xml);
        return this.getXStreamWithoutFormat().fromXML(xml);
    }

    public String serialize(boolean withFormat) {
        StringWriter stringWriter = new StringWriter();
        if (withFormat) {
            this.getXStreamWithFormat().marshal((Object)this.wesData, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)stringWriter));
        } else {
            this.getXStreamWithoutFormat().marshal((Object)this.wesData, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)stringWriter));
        }
        return stringWriter.toString();
    }

    public String buildCGX() {
        return this.convertXMLToCGX(this.serialize(true));
    }

    private String convertXMLToCGX(String xml) {
        StringWriter cgx = new StringWriter();
        String pattern = " command=\\\"([^\\\"]*)\\\"";
        Pattern p = Pattern.compile(pattern);
        try (PrintWriter pw = new PrintWriter(cgx);){
            String[] arr = xml.split("\\r?\\n");
            List<String> allLines = Arrays.asList(arr);
            for (String line : allLines) {
                Matcher matcher = p.matcher(line);
                String command = "";
                if (matcher.find()) {
                    line = matcher.replaceFirst("");
                    command = matcher.group(1);
                    if (StringUtils.contains((String)line, (String)"%xml")) {
                        int idxStart = line.indexOf("<");
                        int idxStop = line.indexOf(">", idxStart);
                        String startTag = line.substring(idxStart + 1, idxStop);
                        int idx2Start = line.indexOf("</");
                        int idx2Stop = line.indexOf(">", idx2Start);
                        String endTag = line.substring(idx2Start + 1, idx2Stop);
                        pw.write("t <" + startTag + ">\n");
                        pw.write("c " + command + "\n");
                        pw.write("t <" + endTag + ">\n");
                        continue;
                    }
                    pw.write("c " + command + line + "\n");
                    continue;
                }
                pw.write("t " + line + "\n");
            }
        }
        return cgx.toString();
    }
}

