/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.communicator.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.model.data.TeleInfo;
import org.rockhopper.smarthome.wes.jwes.model.data.WesData;
import org.rockhopper.smarthome.wes.jwes.model.data.WesOneWireRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesPulseCounter;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCard;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCards;
import org.rockhopper.smarthome.wes.jwes.model.data.WesSensor;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;

public class XmlProtocol {
    private static Map<String, String> commands;
    private static Map<String, String> formats;
    protected String WES_DATA_INFO_DATE_CMD = "g d";
    protected String WES_DATA_INFO_DATE_FMT = "%02d/%02d/%02d";
    protected String WES_DATA_INFO_TIME_CMD = "h h";
    protected String WES_DATA_INFO_TIME_FMT = "%02d:%02d";
    protected String WES_DATA_INFO_FIRMWARE_CMD = "v v";
    protected String WES_DATA_INFO_FIRMWARE_FMT = "%s";
    protected String WES_DATA_INFO_NBTEMPSENSORS_CMD = "W Q";
    protected String WES_DATA_INFO_NBTEMPSENSORS_FMT = "%d";
    protected String WES_DATA_INFO_NBHUMIDSENSORS_CMD = "W H";
    protected String WES_DATA_INFO_NBHUMIDSENSORS_FMT = "%d";
    protected String WES_DATA_INFO_NBRELAYSCARDS_CMD = "WRn";
    protected String WES_DATA_INFO_NBRELAYSCARDS_FMT = "%d";
    protected String WES_DATA_RELAYSCARDS_STATES_CMD = "o W";
    protected String WES_RELAYSCARDS_STATES_FMT = "%xml";

    public XmlProtocol() {
        this(null);
    }

    public XmlProtocol(WesData wesData) {
        if (wesData == null) {
            this.init(new WesData());
        } else {
            this.init(wesData);
        }
    }

    private void init(WesData wesData) {
        WesRelaysCards relaysCards;
        if (wesData == null) {
            throw new UnsupportedOperationException("You must provide an instance of WesData");
        }
        HashMap<String, String> _commands = new HashMap<String, String>();
        HashMap<String, String> _formats = new HashMap<String, String>();
        if (wesData.getInfo() != null) {
            if (wesData.getInfo().getDate() != null) {
                _commands.put(wesData.getInfo().getDate().getLabel(), this.WES_DATA_INFO_DATE_CMD);
                _formats.put(wesData.getInfo().getDate().getLabel(), this.WES_DATA_INFO_DATE_FMT);
            }
            if (wesData.getInfo().getTime() != null) {
                _commands.put(wesData.getInfo().getTime().getLabel(), this.WES_DATA_INFO_TIME_CMD);
                _formats.put(wesData.getInfo().getTime().getLabel(), this.WES_DATA_INFO_TIME_FMT);
            }
            if (wesData.getInfo().getFirmware() != null) {
                _commands.put(wesData.getInfo().getFirmware().getLabel(), this.WES_DATA_INFO_FIRMWARE_CMD);
                _formats.put(wesData.getInfo().getFirmware().getLabel(), this.WES_DATA_INFO_FIRMWARE_FMT);
            }
            if (wesData.getInfo().getNbTempSensors() != null) {
                _commands.put(wesData.getInfo().getNbTempSensors().getLabel(), this.WES_DATA_INFO_NBTEMPSENSORS_CMD);
                _formats.put(wesData.getInfo().getNbTempSensors().getLabel(), this.WES_DATA_INFO_NBTEMPSENSORS_FMT);
            }
            if (wesData.getInfo().getNbHumidSensors() != null) {
                _commands.put(wesData.getInfo().getNbHumidSensors().getLabel(), this.WES_DATA_INFO_NBHUMIDSENSORS_CMD);
                _formats.put(wesData.getInfo().getNbHumidSensors().getLabel(), this.WES_DATA_INFO_NBHUMIDSENSORS_FMT);
            }
            if (wesData.getInfo().getNbRelaysCards() != null) {
                _commands.put(wesData.getInfo().getNbRelaysCards().getLabel(), this.WES_DATA_INFO_NBRELAYSCARDS_CMD);
                _formats.put(wesData.getInfo().getNbRelaysCards().getLabel(), this.WES_DATA_INFO_NBRELAYSCARDS_FMT);
            }
        }
        TeleInfoXmlProtocol teleInfoXmlProtocol = new TeleInfoXmlProtocol(_commands, _formats);
        teleInfoXmlProtocol.initTic(wesData.getTic1());
        teleInfoXmlProtocol.initTic(wesData.getTic2());
        teleInfoXmlProtocol.initTic(wesData.getTic3());
        WesRelayXmlProtocol wesRelayXmlProtocol = new WesRelayXmlProtocol(_commands, _formats);
        wesRelayXmlProtocol.initWesRelay(wesData.getRelay1());
        wesRelayXmlProtocol.initWesRelay(wesData.getRelay2());
        if (wesData.getSensors() != null) {
            WesSensorXmlProtocol wesSensorXmlProtocol = new WesSensorXmlProtocol(_commands, _formats);
            for (WesSensor sensor : wesData.getSensors()) {
                wesSensorXmlProtocol.initSensor(sensor);
            }
        }
        if ((relaysCards = wesData.getRelaysCards()) != null) {
            WesRelaysCardXmlProtocol wesRelaysCardXmlProtocol = new WesRelaysCardXmlProtocol(_commands, _formats);
            if (relaysCards.getCards() != null) {
                for (WesRelaysCard card : relaysCards.getCards()) {
                    wesRelaysCardXmlProtocol.initWesRelaysCard(card);
                }
            }
        }
        _commands.put("data.relaysCards.states", this.WES_DATA_RELAYSCARDS_STATES_CMD);
        _formats.put("data.relaysCards.states", this.WES_RELAYSCARDS_STATES_FMT);
        commands = Collections.unmodifiableMap(_commands);
        formats = Collections.unmodifiableMap(_formats);
    }

    public String getWesCommand(Field<?, ?> field) {
        if (field == null || field.getLabel() == null) {
            return null;
        }
        return commands.get(field.getLabel());
    }

    public String getWesFormat(Field<?, ?> field) {
        if (field == null || field.getLabel() == null) {
            return null;
        }
        return formats.get(field.getLabel());
    }

    private static class TeleInfoXmlProtocol {
        private Map<String, String> _commands = new HashMap<String, String>();
        private Map<String, String> _formats = new HashMap<String, String>();
        protected String WES_DATA_TELEINFO_NAME_CMD = "en%d";
        protected String WES_DATA_TELEINFO_NBRELAYSCARDS_FMT = "%s";
        protected String WES_DATA_TELEINFO_ADCO_CMD = "ea%d";
        protected String WES_DATA_TELEINFO_ADCO_FMT = "%s";
        protected String WES_DATA_TELEINFO_ABONAME_CMD = "eN%d";
        protected String WES_DATA_TELEINFO_ABONAME_FMT = "%s";
        protected String WES_DATA_TELEINFO_INDEXN_CMD = "Ti%d%d";
        protected String WES_DATA_TELEINFO_INDEXN_FMT = "%s";
        protected String WES_DATA_TELEINFO_IABO_CMD = "es%d";
        protected String WES_DATA_TELEINFO_IABO_FMT = "%d";
        protected String WES_DATA_TELEINFO_IINSTN_CMD = "ii%d%d";
        protected String WES_DATA_TELEINFO_IINSTN_FMT = "%d";
        protected String WES_DATA_TELEINFO_PAPPS_CMD = "iP";
        protected String WES_DATA_TELEINFO_PAPPS_FMT = "%lu,%lu,%lu";
        protected String WES_DATA_TELEINFO_VOLTAGES_CMD = "iU%d";
        protected String WES_DATA_TELEINFO_VOLTAGES_FMT = "%lu,%lu,%lu";

        public TeleInfoXmlProtocol(Map<String, String> _commands, Map<String, String> _formats) {
            this._commands = _commands;
            this._formats = _formats;
        }

        public void initTic(TeleInfo teleinfo) {
            if (teleinfo == null) {
                return;
            }
            if (teleinfo.getName() != null) {
                this._commands.put(teleinfo.getName().getLabel(), this.getCommandByIndex(this.WES_DATA_TELEINFO_NAME_CMD, teleinfo.getIndex()));
                this._formats.put(teleinfo.getName().getLabel(), this.WES_DATA_TELEINFO_NBRELAYSCARDS_FMT);
            }
            if (teleinfo.getAdco() != null) {
                this._commands.put(teleinfo.getAdco().getLabel(), this.getCommandByIndex(this.WES_DATA_TELEINFO_ADCO_CMD, teleinfo.getIndex()));
                this._formats.put(teleinfo.getAdco().getLabel(), this.WES_DATA_TELEINFO_ADCO_FMT);
            }
            if (teleinfo.getAboName() != null) {
                this._commands.put(teleinfo.getAboName().getLabel(), this.getCommandByIndex(this.WES_DATA_TELEINFO_ABONAME_CMD, teleinfo.getIndex()));
                this._formats.put(teleinfo.getAboName().getLabel(), this.WES_DATA_TELEINFO_ABONAME_FMT);
            }
            if (teleinfo.getIndex1() != null) {
                this._commands.put(teleinfo.getIndex1().getLabel(), this.getCommandByIndexAndPhaseNb(this.WES_DATA_TELEINFO_INDEXN_CMD, teleinfo.getIndex(), (byte)1));
                this._formats.put(teleinfo.getIndex1().getLabel(), this.WES_DATA_TELEINFO_INDEXN_FMT);
            }
            if (teleinfo.getiAbo() != null) {
                this._commands.put(teleinfo.getiAbo().getLabel(), this.getCommandByIndex(this.WES_DATA_TELEINFO_IABO_CMD, teleinfo.getIndex()));
                this._formats.put(teleinfo.getiAbo().getLabel(), this.WES_DATA_TELEINFO_IABO_FMT);
            }
            if (teleinfo.getIinstMono() != null) {
                this._commands.put(teleinfo.getIinstMono().getLabel(), this.getCommandByIndexAndPhaseNb(this.WES_DATA_TELEINFO_IINSTN_CMD, teleinfo.getIndex(), (byte)0));
                this._formats.put(teleinfo.getIinstMono().getLabel(), this.WES_DATA_TELEINFO_IINSTN_FMT);
            }
            if (teleinfo.getpApps() != null) {
                this._commands.put(teleinfo.getpApps().getLabel(), this.getCommandByIndex(this.WES_DATA_TELEINFO_PAPPS_CMD, teleinfo.getIndex()));
                this._formats.put(teleinfo.getpApps().getLabel(), this.WES_DATA_TELEINFO_PAPPS_FMT);
            }
            if (teleinfo.getVoltages() != null) {
                this._commands.put(teleinfo.getVoltages().getLabel(), this.getCommandByIndex(this.WES_DATA_TELEINFO_VOLTAGES_CMD, teleinfo.getIndex()));
                this._formats.put(teleinfo.getVoltages().getLabel(), this.WES_DATA_TELEINFO_VOLTAGES_FMT);
            }
        }

        private String getCommandByIndex(String parametrizedCommand, byte index) {
            return String.format(parametrizedCommand, index);
        }

        private String getCommandByIndexAndPhaseNb(String parametrizedCommand, byte index, byte n) {
            return String.format(parametrizedCommand, index, n);
        }
    }

    private static class WesRelayXmlProtocol {
        private Map<String, String> _commands = new HashMap<String, String>();
        private Map<String, String> _formats = new HashMap<String, String>();
        protected String WES_DATA_RELAY_NAME_CMD = "o n%d";
        protected String WES_DATA_RELAY_NAME_FMT = "%s";
        protected String WES_DATA_RELAY_VALUE_CMD = "o E%d";
        protected String WES_DATA_RELAY_VALUE_FMT = "%d";

        public WesRelayXmlProtocol(Map<String, String> _commands, Map<String, String> _formats) {
            this._commands = _commands;
            this._formats = _formats;
        }

        public void initWesRelay(WesRelay relay) {
            if (relay == null) {
                return;
            }
            if (relay.getName() != null) {
                this._commands.put(relay.getName().getLabel(), this.getCommandByIndex(this.WES_DATA_RELAY_NAME_CMD, (byte)(relay.getIndex() - 1)));
                this._formats.put(relay.getName().getLabel(), this.WES_DATA_RELAY_NAME_FMT);
            }
            if (relay.getValue() != null) {
                this._commands.put(relay.getValue().getLabel(), this.getCommandByIndex(this.WES_DATA_RELAY_VALUE_CMD, relay.getIndex()));
                this._formats.put(relay.getValue().getLabel(), this.WES_DATA_RELAY_VALUE_FMT);
            }
        }

        private String getCommandByIndex(String parametrizedCommand, byte index) {
            return String.format(parametrizedCommand, index);
        }
    }

    private static class WesSensorXmlProtocol {
        private Map<String, String> _commands = new HashMap<String, String>();
        private Map<String, String> _formats = new HashMap<String, String>();
        protected String WES_DATA_SENSOR_ID_CMD = "W%sS%s";
        protected String WES_DATA_SENSOR_ID_FMT = "%02X %02X %02X %02X %02X %02X %02X %02X";
        protected String WES_DATA_SENSOR_NAME_CMD = "W%sN%s";
        protected String WES_DATA_SENSOR_NAME_FMT = "%s";
        protected String WES_DATA_SENSOR_TYPE_CMD = "W%st%s";
        protected String WES_DATA_SENSOR_TYPE_FMT = "%s";
        protected String WES_DATA_SENSOR_VALUE_CMD = "W%sT%s";
        protected String WES_DATA_SENSOR_VALUE_FMT = "%.01f";

        public WesSensorXmlProtocol(Map<String, String> _commands, Map<String, String> _formats) {
            this._commands = _commands;
            this._formats = _formats;
        }

        public void initSensor(WesSensor sensor) {
            if (sensor == null) {
                return;
            }
            if (sensor.getId() != null) {
                this._commands.put(sensor.getId().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_SENSOR_ID_CMD, sensor.getIndex()));
                this._formats.put(sensor.getId().getLabel(), this.WES_DATA_SENSOR_ID_FMT);
            }
            if (sensor.getName() != null) {
                this._commands.put(sensor.getName().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_SENSOR_NAME_CMD, sensor.getIndex()));
                this._formats.put(sensor.getName().getLabel(), this.WES_DATA_SENSOR_NAME_FMT);
            }
            if (sensor.getType() != null) {
                this._commands.put(sensor.getType().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_SENSOR_TYPE_CMD, sensor.getIndex()));
                this._formats.put(sensor.getType().getLabel(), this.WES_DATA_SENSOR_TYPE_FMT);
            }
            if (sensor.getValue() != null) {
                this._commands.put(sensor.getValue().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_SENSOR_VALUE_CMD, sensor.getIndex()));
                this._formats.put(sensor.getValue().getLabel(), this.WES_DATA_SENSOR_VALUE_FMT);
            }
        }

        private char[] getIndexAsChars(byte index) {
            String formattedId = StringUtils.leftPad((String)String.valueOf(index), (int)2, (char)'0');
            return formattedId.toCharArray();
        }

        private String getCommandByIndexAsChars(String parametrizedCommand, byte index) {
            char[] indexAsChars = this.getIndexAsChars(index);
            return String.format(parametrizedCommand, Character.valueOf(indexAsChars[0]), Character.valueOf(indexAsChars[1]));
        }
    }

    private static class WesRelaysCardXmlProtocol {
        private Map<String, String> _commands = new HashMap<String, String>();
        private Map<String, String> _formats = new HashMap<String, String>();
        protected String WES_DATA_RELAYSCARD_ID_CMD = "WRS%d";
        protected String WES_DATA_RELAYSCARD_ID_FMT = "%02X %02X %02X %02X %02X %02X %02X %02X";
        protected String WES_DATA_RELAYSCARD_NAME_CMD = "WRN%d";
        protected String WES_DATA_RELAYSCARD_NAME_FMT = "%s";
        protected String WES_DATA_RELAYSCARD_TYPE_CMD = "?";
        protected String WES_DATA_RELAYSCARD_TYPE_FMT = "?";
        protected String WES_DATA_RELAYSCARD_STATES_CMD = "?";
        protected String WES_DATA_RELAYSCARD_STATES_FMT = "?";

        public WesRelaysCardXmlProtocol(Map<String, String> _commands, Map<String, String> _formats) {
            this._commands = _commands;
            this._formats = _formats;
        }

        public void initWesRelaysCard(WesRelaysCard wesRelaysCard) {
            List<WesOneWireRelay> wesOneWireRelays;
            if (wesRelaysCard == null) {
                return;
            }
            if (wesRelaysCard.getId() != null) {
                this._commands.put(wesRelaysCard.getId().getLabel(), this.getCommandByIndex(this.WES_DATA_RELAYSCARD_ID_CMD, wesRelaysCard.getIndex()));
                this._formats.put(wesRelaysCard.getId().getLabel(), this.WES_DATA_RELAYSCARD_ID_FMT);
            }
            if (wesRelaysCard.getName() != null) {
                this._commands.put(wesRelaysCard.getName().getLabel(), this.getCommandByIndex(this.WES_DATA_RELAYSCARD_NAME_CMD, wesRelaysCard.getIndex()));
                this._formats.put(wesRelaysCard.getName().getLabel(), this.WES_DATA_RELAYSCARD_NAME_FMT);
            }
            if (wesRelaysCard.getCardType() != null) {
                this._commands.put(wesRelaysCard.getCardType().getLabel(), this.getCommandByIndex(this.WES_DATA_RELAYSCARD_TYPE_CMD, wesRelaysCard.getIndex()));
                this._formats.put(wesRelaysCard.getCardType().getLabel(), this.WES_DATA_RELAYSCARD_TYPE_FMT);
            }
            if ((wesOneWireRelays = wesRelaysCard.getRelays()) != null) {
                WesOneWireRelayXmlProtocol oneWireRelayXmlProtocol = new WesOneWireRelayXmlProtocol(this._commands, this._formats);
                for (WesOneWireRelay oneWirerelay : wesOneWireRelays) {
                    oneWireRelayXmlProtocol.initWesOneWireRelay(oneWirerelay);
                }
            }
        }

        private String getCommandByIndex(String parametrizedCommand, byte index) {
            return String.format(parametrizedCommand, index);
        }
    }

    private static class WesOneWireRelayXmlProtocol {
        private Map<String, String> _commands = new HashMap<String, String>();
        private Map<String, String> _formats = new HashMap<String, String>();
        protected String WES_DATA_RELAY_NAME_CMD = "WR%d%d";
        protected String WES_DATA_RELAY_NAME_FMT = "%s";

        public WesOneWireRelayXmlProtocol(Map<String, String> _commands, Map<String, String> _formats) {
            this._commands = _commands;
            this._formats = _formats;
        }

        public void initWesOneWireRelay(WesOneWireRelay relay) {
            if (relay == null) {
                return;
            }
            if (relay.getName() != null) {
                this._commands.put(relay.getName().getLabel(), WesOneWireRelayXmlProtocol.getCommandByCardIndexAndIndex(this.WES_DATA_RELAY_NAME_CMD, relay.getCardIndex(), relay.getIndex()));
                this._formats.put(relay.getName().getLabel(), this.WES_DATA_RELAY_NAME_FMT);
            }
        }

        private static String getCommandByCardIndexAndIndex(String parametrizedCommand, byte cardIndex, byte index) {
            return String.format(parametrizedCommand, cardIndex, index);
        }
    }

    private static class WesPulseCounterXmlProtocol {
        private Map<String, String> _commands = new HashMap<String, String>();
        private Map<String, String> _formats = new HashMap<String, String>();
        protected String WES_DATA_PULSECOUNTER_NAME_CMD = "pn%s";
        protected String WES_DATA_PULSECOUNTER_NAME_FMT = "%s";
        protected String WES_DATA_PULSECOUNTER_DEBIT_CMD = "pd%s";
        protected String WES_DATA_PULSECOUNTER_DEBIT_FMT = "%.02f";
        protected String WES_DATA_PULSECOUNTER_CURRENTINDEX_CMD = "pIU%s";
        protected String WES_DATA_PULSECOUNTER_CURRENTINDEX_FMT = "%.0f";
        protected String WES_DATA_PULSECOUNTER_YESTERDAY_CMD = "pCh%s";
        protected String WES_DATA_PULSECOUNTER_YESTERDAY_FMT = "%.0f";
        protected String WES_DATA_PULSECOUNTER_TODAY_CMD = "pCj%s";
        protected String WES_DATA_PULSECOUNTER_TODAY_FMT = "%.0f";
        protected String WES_DATA_PULSECOUNTER_MONTH_CMD = "pCm%s";
        protected String WES_DATA_PULSECOUNTER_MONTH_FMT = "%.3f";
        protected String WES_DATA_PULSECOUNTER_YEAR_CMD = "pCa%s";
        protected String WES_DATA_PULSECOUNTER_YEAR_FMT = "%.3f";

        public WesPulseCounterXmlProtocol(Map<String, String> _commands, Map<String, String> _formats) {
            this._commands = _commands;
            this._formats = _formats;
        }

        public void initPulseCounter(WesPulseCounter pulseCounter) {
            if (pulseCounter == null) {
                return;
            }
            if (pulseCounter.getName() != null) {
                this._commands.put(pulseCounter.getName().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_NAME_CMD, pulseCounter.getIndex()));
                this._formats.put(pulseCounter.getName().getLabel(), this.WES_DATA_PULSECOUNTER_NAME_FMT);
            }
            if (pulseCounter.getDebit() != null) {
                this._commands.put(pulseCounter.getDebit().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_DEBIT_CMD, pulseCounter.getIndex()));
                this._formats.put(pulseCounter.getDebit().getLabel(), this.WES_DATA_PULSECOUNTER_DEBIT_FMT);
            }
            if (pulseCounter.getCurrentIndex() != null) {
                this._commands.put(pulseCounter.getCurrentIndex().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_CURRENTINDEX_CMD, pulseCounter.getIndex()));
                this._formats.put(pulseCounter.getCurrentIndex().getLabel(), this.WES_DATA_PULSECOUNTER_CURRENTINDEX_FMT);
            }
            if (pulseCounter.getYesterdayConsumption() != null) {
                this._commands.put(pulseCounter.getYesterdayConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_YESTERDAY_CMD, pulseCounter.getIndex()));
                this._formats.put(pulseCounter.getYesterdayConsumption().getLabel(), this.WES_DATA_PULSECOUNTER_YESTERDAY_FMT);
            }
            if (pulseCounter.getTodayConsumption() != null) {
                this._commands.put(pulseCounter.getTodayConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_TODAY_CMD, pulseCounter.getIndex()));
                this._formats.put(pulseCounter.getTodayConsumption().getLabel(), this.WES_DATA_PULSECOUNTER_TODAY_FMT);
            }
            if (pulseCounter.getMonthConsumption() != null) {
                this._commands.put(pulseCounter.getMonthConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_MONTH_CMD, pulseCounter.getIndex()));
                this._formats.put(pulseCounter.getMonthConsumption().getLabel(), this.WES_DATA_PULSECOUNTER_MONTH_FMT);
            }
            if (pulseCounter.getYearConsumption() != null) {
                this._commands.put(pulseCounter.getYearConsumption().getLabel(), this.getCommandByIndexAsChars(this.WES_DATA_PULSECOUNTER_YEAR_CMD, pulseCounter.getIndex()));
                this._formats.put(pulseCounter.getYearConsumption().getLabel(), this.WES_DATA_PULSECOUNTER_YEAR_FMT);
            }
        }

        private String getCommandByIndexAsChars(String parametrizedCommand, byte index) {
            byte indexForCmd = (byte)(index + 1);
            return String.format(parametrizedCommand, String.valueOf(indexForCmd));
        }
    }
}

