/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.discovery;

import org.rockhopper.smarthome.wes.jwes.WesConstants;
import org.rockhopper.smarthome.wes.jwes.discovery.WesServerDiscoveryService;
import org.rockhopper.smarthome.wes.jwes.discovery.WesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WesPingRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(WesPingRunnable.class);
    private final String ip;
    private int tcpPort;
    private int httpPort;
    private final WesServerDiscoveryService service;

    public WesPingRunnable(String ip, Integer tcpPort, Integer httpPort, WesServerDiscoveryService service) {
        this.ip = ip;
        this.service = service;
        this.tcpPort = tcpPort != null ? tcpPort : WesConstants.DEFAULT_TCP_PORT;
        this.httpPort = httpPort != null ? httpPort : WesConstants.DEFAULT_HTTP_PORT;
        if (this.ip == null) {
            throw new RuntimeException("ip may not be null!");
        }
    }

    @Override
    public void run() {
        try {
            this.logger.debug("WES Ping {}", (Object)this.ip);
            Boolean httpPingResult = WesUtils.httpPing(this.ip, this.httpPort);
            if (httpPingResult != null) {
                if (httpPingResult.booleanValue()) {
                    this.logger.info("Found WES Server IP=[{}]", (Object)this.ip);
                    String macAddress = WesUtils.getMac(this.ip, this.tcpPort);
                    if (macAddress != null) {
                        this.service.newServer(this.ip, macAddress);
                    } else {
                        this.logger.error("Fail to get MacAddress of WES Server with IP {}", (Object)this.ip);
                    }
                } else {
                    this.logger.debug("Network device {} is not a WES!", (Object)this.ip);
                }
            }
        }
        catch (Exception e) {
            this.logger.trace("Fail to ping '{}'", (Object)this.ip, (Object)e);
        }
        finally {
            this.logger.debug("End of WES Ping {}", (Object)this.ip);
        }
    }

    public String getIp() {
        return this.ip;
    }
}

