/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.discovery;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.rockhopper.smarthome.wes.jwes.WesConstants;
import org.rockhopper.smarthome.wes.jwes.discovery.WesPingRunnable;
import org.rockhopper.smarthome.wes.jwes.discovery.WesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class WesServerDiscoveryService {
    private static final Logger logger = LoggerFactory.getLogger(WesServerDiscoveryService.class);
    private Integer tcpPort;
    private Integer httpPort;
    public static final int PING_TIMEOUT_IN_MS = 100;
    private int scanningNetworkSize = 0;
    private boolean discoveryDone = false;
    private Set<String> discoveryInterfaceIPs = null;
    private @Nullable ExecutorService executorService = null;

    public void scan() {
        this.startScan();
        this.awaitTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScan() {
        if (this.executorService != null) {
            this.interruptScan();
            this.discoveryDone = false;
        }
        if (this.tcpPort == null) {
            this.tcpPort = WesConstants.DEFAULT_TCP_PORT;
        }
        if (this.httpPort == null) {
            this.httpPort = WesConstants.DEFAULT_HTTP_PORT;
        }
        logger.debug("Starting WES Server discovery scan");
        TreeSet<String> interfaceIPs = WesUtils.getInterfaceIPs();
        if (this.discoveryInterfaceIPs == null && interfaceIPs.size() > 1) {
            logger.info("List of available InterfacesIP... {}", (Object)String.join((CharSequence)",", interfaceIPs));
            throw new UnsupportedOperationException("Please set an InterfaceIP name to limit discovery effort!");
        }
        interfaceIPs.retainAll(this.discoveryInterfaceIPs);
        LinkedHashSet<String> networkIPs = WesUtils.getNetworkIPs(interfaceIPs);
        this.scanningNetworkSize = networkIPs.size();
        logger.debug("Number of IP Addresses to scan {}", (Object)this.scanningNetworkSize);
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 10);
        WesServerDiscoveryService wesServerDiscoveryService = this;
        synchronized (wesServerDiscoveryService) {
            for (String ip : networkIPs) {
                if (this.executorService == null || this.executorService.isShutdown()) continue;
                WesPingRunnable wesPing = new WesPingRunnable(ip, this.tcpPort, this.httpPort, this);
                this.executorService.execute(wesPing);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void awaitTermination() {
        if (this.executorService != null) {
            WesServerDiscoveryService wesServerDiscoveryService = this;
            synchronized (wesServerDiscoveryService) {
                try {
                    this.executorService.awaitTermination(100 * this.scanningNetworkSize, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.executorService != null) {
                    this.interruptScan();
                }
            }
            logger.debug("Stopping WES Server discovery scan");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptScan() {
        if (this.executorService != null) {
            WesServerDiscoveryService wesServerDiscoveryService = this;
            synchronized (wesServerDiscoveryService) {
                List<Runnable> tasksAwaitingExecution = this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (tasksAwaitingExecution != null && !tasksAwaitingExecution.isEmpty()) {
                    for (Runnable runnable : tasksAwaitingExecution) {
                        if (runnable instanceof WesPingRunnable) {
                            logger.warn("WesPing for IP#{} has not been executed", (Object)((WesPingRunnable)runnable).getIp());
                            continue;
                        }
                        logger.warn("{} has not been executed", (Object)runnable);
                    }
                }
                this.executorService = null;
            }
            this.discoveryDone = true;
        }
    }

    public Boolean isTerminated() {
        return this.discoveryDone;
    }

    public void setTcpPort(Integer tcpPort) {
        this.tcpPort = tcpPort;
    }

    public void setHttpPort(Integer httpPort) {
        this.httpPort = httpPort;
    }

    public void setDiscoveryInterfaceIPs(Set<String> discoveryInterfaceIPs) {
        this.discoveryInterfaceIPs = discoveryInterfaceIPs;
    }

    public void setDiscoveryInterfaceIPs(String discoveryInterfaceIPs) {
        if (StringUtils.isBlank((String)discoveryInterfaceIPs)) {
            return;
        }
        String[] discoveryInterfaceIPsArray = StringUtils.split((String)discoveryInterfaceIPs, (String)",");
        HashSet<String> discoveryInterfaceIPsToSet = new HashSet<String>();
        for (String discoveryInterfaceIP : discoveryInterfaceIPsArray) {
            String currentDiscoveryInterfaceIP = discoveryInterfaceIP.trim();
            if (StringUtils.isEmpty((String)currentDiscoveryInterfaceIP)) continue;
            discoveryInterfaceIPsToSet.add(currentDiscoveryInterfaceIP);
        }
        if (discoveryInterfaceIPsToSet.size() == 0) {
            logger.warn("'discoveryInterfaceIPs' is actually empty!");
        }
        this.setDiscoveryInterfaceIPs(discoveryInterfaceIPsToSet);
    }

    public abstract void newServer(String var1, String var2);
}

