/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.model;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.WesConstants;
import org.rockhopper.smarthome.wes.jwes.communicator.FtpClient;
import org.rockhopper.smarthome.wes.jwes.communicator.WesHttpClient;
import org.rockhopper.smarthome.wes.jwes.communicator.tcp.TcpPolling;
import org.rockhopper.smarthome.wes.jwes.communicator.xml.XmlHandler;
import org.rockhopper.smarthome.wes.jwes.discovery.WesServerDiscoveryService;
import org.rockhopper.smarthome.wes.jwes.discovery.WesUtils;
import org.rockhopper.smarthome.wes.jwes.model.WesConfig;
import org.rockhopper.smarthome.wes.jwes.model.WesEventListener;
import org.rockhopper.smarthome.wes.jwes.model.data.WesData;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;
import org.rockhopper.smarthome.wes.jwes.model.helper.WesLabelsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WesServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String macAddress;
    private WesConfig wesConfig;
    private WesData wesData;
    private XmlHandler xmlHandler;
    private TcpPolling tcpPolling;

    public WesServer(String macAddress) {
        this(macAddress, null);
    }

    public WesServer(String macAddress, WesConfig wesConfig) {
        this.wesConfig = wesConfig;
        this.setMacAddress(macAddress);
        if (wesConfig != null && wesConfig.getIpAddress() != null) {
            this.initialize();
        } else {
            this.initialize(macAddress);
        }
    }

    private void initialize(final String macAddress) {
        WesServerDiscoveryService wesServerDiscoveryService = new WesServerDiscoveryService(){

            @Override
            public void newServer(String newIp, String newMacAddress) {
                WesServer.this.logger.info("Found WES Server with MAC address [{}], the IP Address is [{}]", (Object)newMacAddress, (Object)newIp);
                if (macAddress.equals(newMacAddress)) {
                    WesServer.this.logger.info("We have found the WES Server we were looking: MAC address [{}], IP Address is [{}]", (Object)macAddress, (Object)newIp);
                    if (WesServer.this.wesConfig == null) {
                        WesServer.this.wesConfig = new WesConfig(newIp);
                    } else {
                        WesServer.this.wesConfig.setIpAddress(newIp);
                    }
                    this.interruptScan();
                }
            }
        };
        if (this.wesConfig != null) {
            wesServerDiscoveryService.setDiscoveryInterfaceIPs(this.wesConfig.getDiscoveryInterfaceIPs());
            wesServerDiscoveryService.setTcpPort(this.wesConfig.getTcpPort());
        }
        wesServerDiscoveryService.setHttpPort(WesConstants.DEFAULT_HTTP_PORT);
        wesServerDiscoveryService.scan();
        if (this.wesConfig != null && this.wesConfig.getIpAddress() != null) {
            this.initialize(true);
        }
    }

    private void initialize() {
        this.initialize(false);
    }

    private void initialize(boolean skipMacAddressCheck) {
        if (this.wesConfig == null || this.wesConfig.getIpAddress() == null) {
            throw new UnsupportedOperationException("Cannot initialize WES with IP Address");
        }
        this.logger.info("About to initialize WesServer[{}] using IP Address[{}]", (Object)this.macAddress, (Object)this.wesConfig.getIpAddress());
        if (!skipMacAddressCheck) {
            if (!this.checkMac()) {
                this.logger.warn("The MAC address for IP Address is not matching the expected WES MAC Address. Fallback to MAC Address initialization.");
                this.initialize(this.macAddress);
            } else {
                this.logger.debug("MAC address [{}] is checked!", (Object)this.macAddress);
            }
        }
        this.initPhase1();
    }

    private void initPhase1() {
        this.wesData = WesData.getInstance(30, 10);
        WesLabelsHelper.label(this.wesData);
        this.xmlHandler = new XmlHandler(this.wesData);
        try (InputStream cgx = IOUtils.toInputStream((String)this.xmlHandler.buildCGX(), (String)"ISO-8859-1");){
            this.uploadFile(cgx, "PHASE1.CGX");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.wesData = (WesData)this.xmlHandler.deserialize(this.download("PHASE1.CGX", this.wesConfig.getHttpUser(), this.wesConfig.getHttpPass()));
        this.xmlHandler = new XmlHandler(this.wesData);
    }

    private boolean checkMac() {
        String netWorkMACAddress = WesUtils.getMac(this.wesConfig.getIpAddress(), this.wesConfig.getTcpPort());
        if (netWorkMACAddress == null) {
            throw new RuntimeException("Fail to check MAC Address for WES[" + this.macAddress + "] (using IP [" + this.wesConfig.getIpAddress() + "])");
        }
        return netWorkMACAddress.equals(this.macAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(InputStream localStreamToUpload, String remoteFileName) {
        block13: {
            FtpClient ftpClient = null;
            try {
                ftpClient = new FtpClient(this.getWesConfig().getIpAddress());
                boolean logged = ftpClient.login(this.getWesConfig().getFtpUser(), this.getWesConfig().getFtpPass());
                if (!logged) break block13;
                try (BufferedInputStream bis = new BufferedInputStream(localStreamToUpload);){
                    ftpClient.changeWorkingDirectory("/JWES");
                    ftpClient.uploadFile(remoteFileName, bis);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (ftpClient != null) {
                    ftpClient.logout();
                }
            }
        }
    }

    private String download(String remoteFileName, String httpUser, String httpPass) {
        WesHttpClient httpClient = new WesHttpClient(this.wesConfig.getIpAddress(), WesConstants.DEFAULT_HTTP_PORT);
        httpClient.login(httpUser, httpPass);
        return httpClient.httpGet("/JWES/" + remoteFileName);
    }

    public Set<Field<?, ?>> label() {
        if (this.wesData != null && !this.wesData.isTruncated()) {
            this.wesData.truncate();
            return WesLabelsHelper.label(this.wesData);
        }
        return null;
    }

    public boolean startPolling(WesEventListener eventListener) {
        if (this.wesData != null && !this.wesData.isTruncated()) {
            this.wesData.truncate();
        }
        this.tcpPolling = new TcpPolling(this.wesConfig.getIpAddress(), this.wesConfig.getTcpPort(), this.wesData);
        this.tcpPolling.setEventListener(eventListener);
        this.tcpPolling.run();
        return true;
    }

    public void stopPolling() {
        if (this.tcpPolling != null) {
            this.tcpPolling.halt();
        }
    }

    public WesConfig getWesConfig() {
        return this.wesConfig;
    }

    public WesData getWesData() {
        return this.wesData;
    }

    public void setMacAddress(String macAddress) {
        if (macAddress != null) {
            boolean isValid = false;
            String rawMacAddress = StringUtils.remove((String)macAddress, (String)":");
            if (rawMacAddress.length() == 12) {
                try {
                    Base64.getDecoder().decode(rawMacAddress);
                    isValid = true;
                }
                catch (IllegalArgumentException iae) {
                    this.logger.error("Fail to parse WES MAC Address []", (Object)rawMacAddress, (Object)iae);
                }
            }
            if (!isValid) {
                this.logger.error("Given WES MAC Address is invalid []", (Object)macAddress);
            }
        }
        this.macAddress = macAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public <V, W> void forceUpdate(Field<V, W> field, V newValue) {
        if (this.tcpPolling != null) {
            this.tcpPolling.forceUpdate(field, newValue);
        }
    }
}

