/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.model.data;

import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;

public class TeleInfo {
    public static final String DISABLED_ADCO_VALUE = "Pas Dispo";
    private byte index;
    private Field<String, Void> name;
    private Field<String, Void> adco;
    private Field<String, Void> aboName;
    private Field<String, Void> index1;
    private Field<Byte, Void> iAbo;
    private Field<Byte, Void> iinstMono;
    private Field<String, Void> pApps;
    private Field<String, Void> voltages;

    public TeleInfo(byte index) {
        if (index <= 0 || index > 3) {
            throw new UnsupportedOperationException("TIC index is 1 to 3");
        }
        this.index = index;
        this.name = new Field(Field.PRIORITY_DISCOVERY);
        this.adco = new Field(Field.PRIORITY_DISCOVERY);
        this.aboName = new Field(Field.PRIORITY_DISCOVERY);
        this.index1 = new Field(Field.PRIORITY_MEDIUM);
        this.iAbo = new Field(Byte.class, Field.PRIORITY_DISCOVERY);
        this.iinstMono = new Field(Byte.class, Field.PRIORITY_MEDIUM);
        this.pApps = new Field(Field.PRIORITY_HIGH);
        this.voltages = new Field(Field.PRIORITY_DISCOVERY);
    }

    public byte getIndex() {
        return this.index;
    }

    public void setIndex(byte index) {
        this.index = index;
    }

    public Field<String, Void> getName() {
        return this.name;
    }

    public void setName(Field<String, Void> name) {
        this.name = name;
    }

    public Field<String, Void> getAdco() {
        return this.adco;
    }

    public void setAdco(Field<String, Void> adco) {
        this.adco = adco;
    }

    public Field<String, Void> getAboName() {
        return this.aboName;
    }

    public void setAboName(Field<String, Void> aboName) {
        this.aboName = aboName;
    }

    public Field<String, Void> getIndex1() {
        return this.index1;
    }

    public void setIndex1(Field<String, Void> index1) {
        this.index1 = index1;
    }

    public Field<Byte, Void> getiAbo() {
        return this.iAbo;
    }

    public void setiAbo(Field<Byte, Void> iAbo) {
        this.iAbo = iAbo;
    }

    public Field<Byte, Void> getIinstMono() {
        return this.iinstMono;
    }

    public void setIinstMono(Field<Byte, Void> iinstMono) {
        this.iinstMono = iinstMono;
    }

    public Field<String, Void> getpApps() {
        return this.pApps;
    }

    public void setpApps(Field<String, Void> pApps) {
        this.pApps = pApps;
    }

    public Field<String, Void> getVoltages() {
        return this.voltages;
    }

    public void setVoltages(Field<String, Void> voltages) {
        this.voltages = voltages;
    }

    public Boolean isEnabled() {
        Boolean enabled = null;
        if (this.adco != null && this.adco.getValue() != null) {
            enabled = DISABLED_ADCO_VALUE.equals(this.adco.getValue()) ? Boolean.FALSE : Boolean.TRUE;
        }
        return enabled;
    }
}

