/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.model.data;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.rockhopper.smarthome.wes.jwes.model.data.TeleInfo;
import org.rockhopper.smarthome.wes.jwes.model.data.WesInfo;
import org.rockhopper.smarthome.wes.jwes.model.data.WesPulseCounter;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCards;
import org.rockhopper.smarthome.wes.jwes.model.data.WesSensor;

@XStreamAlias(value="data")
public class WesData {
    private transient boolean truncated = false;
    private WesInfo info = new WesInfo();
    private TeleInfo tic1 = new TeleInfo(1);
    private TeleInfo tic2 = new TeleInfo(2);
    private TeleInfo tic3 = new TeleInfo(3);
    private WesRelay relay1 = new WesRelay(1);
    private WesRelay relay2 = new WesRelay(2);
    @XStreamImplicit(itemFieldName="pulseCounter")
    private List<WesPulseCounter> pulseCounters;
    @XStreamImplicit(itemFieldName="sensor")
    private List<WesSensor> sensors;
    private WesRelaysCards relaysCards;

    public WesInfo getInfo() {
        return this.info;
    }

    public void setInfo(WesInfo info) {
        this.info = info;
    }

    public TeleInfo getTic1() {
        return this.tic1;
    }

    public void setTic1(TeleInfo tic1) {
        this.tic1 = tic1;
    }

    public TeleInfo getTic2() {
        return this.tic2;
    }

    public void setTic2(TeleInfo tic2) {
        this.tic2 = tic2;
    }

    public TeleInfo getTic3() {
        return this.tic3;
    }

    public void setTic3(TeleInfo tic3) {
        this.tic3 = tic3;
    }

    public WesRelay getRelay1() {
        return this.relay1;
    }

    public void setRelay1(WesRelay relay1) {
        this.relay1 = relay1;
    }

    public WesRelay getRelay2() {
        return this.relay2;
    }

    public void setRelay2(WesRelay relay2) {
        this.relay2 = relay2;
    }

    public List<WesPulseCounter> getPulseCounters() {
        return this.pulseCounters;
    }

    public WesRelaysCards getRelaysCards() {
        return this.relaysCards;
    }

    public void setRelaysCards(WesRelaysCards relaysCards) {
        this.relaysCards = relaysCards;
    }

    public List<WesSensor> getSensors() {
        return this.sensors;
    }

    public void addSensor(WesSensor sensor) {
        if (this.sensors == null) {
            this.sensors = new ArrayList<WesSensor>(30);
        }
        this.sensors.add(sensor);
    }

    public void truncate() {
        Boolean ticEnabled;
        Boolean ticEnabled2;
        Boolean ticEnabled3;
        if (this.info != null) {
            if (this.info.getNbHumidSensors() != null && this.info.getNbHumidSensors().getValue() != null && this.info.getNbTempSensors() != null && this.info.getNbTempSensors().getValue() != null) {
                int nbSensors = this.info.getNbHumidSensors().getValue() + this.info.getNbTempSensors().getValue();
                if (this.sensors != null && this.sensors.size() > nbSensors) {
                    this.sensors.subList(nbSensors, this.sensors.size()).clear();
                }
            }
            if (this.info.getNbRelaysCards() != null && this.info.getNbRelaysCards().getValue() != null) {
                this.relaysCards.truncateTo(this.info.getNbRelaysCards().getValue());
            }
        }
        if (this.tic1 != null && (ticEnabled3 = this.tic1.isEnabled()) != null && !ticEnabled3.booleanValue()) {
            this.tic1 = null;
        }
        if (this.tic2 != null && (ticEnabled2 = this.tic2.isEnabled()) != null && !ticEnabled2.booleanValue()) {
            this.tic2 = null;
        }
        if (this.tic3 != null && (ticEnabled = this.tic3.isEnabled()) != null && !ticEnabled.booleanValue()) {
            this.tic3 = null;
        }
        this.truncated = true;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final WesData getInstance(int nbSensors, int nbRelaysCard) {
        WesData wesData = new WesData();
        if (nbSensors > 0) {
            for (int i = 0; i < nbSensors; ++i) {
                wesData.addSensor(new WesSensor((byte)i));
            }
        }
        if (nbRelaysCard > 0) {
            wesData.setRelaysCards(new WesRelaysCards((byte)nbRelaysCard));
        }
        return wesData;
    }
}

