/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.model.data;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.math.BigDecimal;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;

@XStreamAlias(value="pulseCounter")
public class WesPulseCounter {
    private byte index;
    private Field<String, Void> name;
    private Field<BigDecimal, Void> debit;
    private Field<BigDecimal, Void> currentIndex;
    private Field<BigDecimal, Void> todayConsumption;
    private Field<BigDecimal, Void> yesterdayConsumption;
    private Field<BigDecimal, Void> monthConsumption;
    private Field<BigDecimal, Void> YearConsumption;

    public WesPulseCounter(byte index) {
        if (index < 0 || index > 3) {
            throw new UnsupportedOperationException("WES PulseCounter index is 0 to 3");
        }
        this.index = index;
        this.name = new Field(Field.PRIORITY_DISCOVERY);
        this.debit = new Field(BigDecimal.class, Field.PRIORITY_REALTIME);
        this.currentIndex = new Field(BigDecimal.class, Field.PRIORITY_HIGH);
        this.todayConsumption = new Field(BigDecimal.class, Field.PRIORITY_HIGH);
        this.yesterdayConsumption = new Field(BigDecimal.class, Field.PRIORITY_LOW);
        this.monthConsumption = new Field(BigDecimal.class, Field.PRIORITY_LOW);
        this.YearConsumption = new Field(BigDecimal.class, Field.PRIORITY_LOW);
    }

    public Field<String, Void> getName() {
        return this.name;
    }

    public void setName(Field<String, Void> name) {
        this.name = name;
    }

    public Field<BigDecimal, Void> getDebit() {
        return this.debit;
    }

    public void setDebit(Field<BigDecimal, Void> debit) {
        this.debit = debit;
    }

    public Field<BigDecimal, Void> getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(Field<BigDecimal, Void> currentIndex) {
        this.currentIndex = currentIndex;
    }

    public Field<BigDecimal, Void> getTodayConsumption() {
        return this.todayConsumption;
    }

    public void setTodayConsumption(Field<BigDecimal, Void> todayConsumption) {
        this.todayConsumption = todayConsumption;
    }

    public Field<BigDecimal, Void> getYesterdayConsumption() {
        return this.yesterdayConsumption;
    }

    public void setYesterdayConsumption(Field<BigDecimal, Void> yesterdayConsumption) {
        this.yesterdayConsumption = yesterdayConsumption;
    }

    public Field<BigDecimal, Void> getMonthConsumption() {
        return this.monthConsumption;
    }

    public void setMonthConsumption(Field<BigDecimal, Void> monthConsumption) {
        this.monthConsumption = monthConsumption;
    }

    public Field<BigDecimal, Void> getYearConsumption() {
        return this.YearConsumption;
    }

    public void setYearConsumption(Field<BigDecimal, Void> yearConsumption) {
        this.YearConsumption = yearConsumption;
    }

    public byte getIndex() {
        return this.index;
    }
}

