/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.model.data;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.model.data.WesOneWireRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;
import org.rockhopper.smarthome.wes.jwes.model.data.type.VirtualField;

@XStreamAlias(value="relayCard")
public class WesRelaysCard
extends Field<String, Void>
implements VirtualField {
    private byte index;
    private Field<String, Void> id;
    private Field<String, Void> name;
    private Field<String, Void> cardType;
    @XStreamImplicit(itemFieldName="relay")
    List<WesOneWireRelay> relays;

    public WesRelaysCard(byte index) {
        this(index, Field.PRIORITY_REALTIME);
        for (int j = 1; j <= 8; ++j) {
            this.addRelay(new WesOneWireRelay(index, (byte)j));
        }
    }

    public WesRelaysCard(byte index, Byte priority) {
        super(priority);
        if (index < 0 || index >= 10) {
            throw new UnsupportedOperationException("WES RelaysCard index is 0 to 9");
        }
        this.index = index;
        this.id = new Field(Field.PRIORITY_DISCOVERY);
        this.name = new Field(Field.PRIORITY_DISCOVERY);
        this.cardType = new Field(Field.PRIORITY_DISCOVERY);
    }

    public void addRelay(WesOneWireRelay relay) {
        if (this.relays == null) {
            this.relays = new ArrayList<WesOneWireRelay>(8);
        }
        this.relays.add(relay);
    }

    public byte getIndex() {
        return this.index;
    }

    public Field<String, Void> getName() {
        return this.name;
    }

    public void setName(Field<String, Void> name) {
        this.name = name;
    }

    public Field<String, Void> getCardType() {
        return this.cardType;
    }

    public void setCardType(Field<String, Void> cardType) {
        this.cardType = cardType;
    }

    public List<WesOneWireRelay> getRelays() {
        return this.relays;
    }

    public void setRelays(List<WesOneWireRelay> relays) {
        this.relays = relays;
    }

    public Field<String, Void> getId() {
        return this.id;
    }

    public String getPrettyId() {
        return this.id != null && this.id.getValue() != null ? StringUtils.deleteWhitespace((String)this.id.getValue()) : null;
    }

    public Field<String, Void> getStates() {
        Field states = null;
        if (this.relays != null) {
            states = new Field(Field.PRIORITY_REALTIME);
            String cardLabel = "data" + String.format(".relaysCards.card%s.states", this.index);
            states.setLabel(cardLabel);
            states.setValue(this.getValue());
        }
        return states;
    }

    public void setStates(Field<String, Void> states) {
        if (states != null && states.getValue() != null) {
            String sStates = states.getValue();
            this.setValue(sStates);
        }
    }

    public Boolean[] getStatesAsBooleanArray() {
        String states = this.getStatesAsString();
        return WesRelaysCard.fromString(states);
    }

    public String getStatesAsString() {
        if (this.relays == null) {
            return null;
        }
        Object states = "";
        for (WesOneWireRelay wesOneWireRelay : this.relays) {
            int state = 32;
            if (wesOneWireRelay.getState() != null && wesOneWireRelay.getState().getValue() != null) {
                state = wesOneWireRelay.getState().getValue() != false ? 49 : 48;
            }
            states = (String)states + (char)state;
        }
        return states;
    }

    private static Boolean[] fromString(String binary) {
        Boolean[] bitset = new Boolean[binary.length()];
        for (int i = 0; i < binary.length(); ++i) {
            bitset[i] = binary.charAt(i) == '1' ? Boolean.valueOf(true) : (binary.charAt(i) == '0' ? Boolean.valueOf(false) : null);
        }
        return bitset;
    }

    public Boolean getState(byte relayIndex) {
        if (this.getRelays() == null) {
            return null;
        }
        WesOneWireRelay relay = this.getRelays().get(relayIndex);
        Field<Boolean, Void> state = null;
        if (relay != null) {
            state = relay.getState();
        }
        return state != null ? state.getValue() : null;
    }

    public void setState(byte relayIndex, Boolean state) {
        if (this.getRelays() == null) {
            return;
        }
        WesOneWireRelay relay = this.getRelays().get(relayIndex);
        if (relay != null) {
            relay.setState(state);
        }
    }

    @Override
    public String getValue() {
        return this.getStatesAsString();
    }

    @Override
    public void setValue(String value) {
        Boolean[] valueAsBooleanArray = this.toBooleanArray(value);
        for (byte i = 0; i < valueAsBooleanArray.length; i = (byte)(i + 1)) {
            this.setState(i, valueAsBooleanArray[i]);
        }
    }

    private Boolean[] toBooleanArray(String value) {
        if (value == null) {
            return null;
        }
        Boolean[] booleanArray = new Boolean[Math.max(value.length(), 8)];
        for (int i = 0; i < Math.min(value.length(), 8); ++i) {
            if (value.charAt(i) == '1') {
                booleanArray[i] = Boolean.TRUE;
                continue;
            }
            if (value.charAt(i) == '0') {
                booleanArray[i] = Boolean.FALSE;
                continue;
            }
            if (value.charAt(i) != ' ') continue;
            booleanArray[i] = null;
        }
        return booleanArray;
    }

    @Override
    public String getMemberName() {
        return "states";
    }
}

