/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.model.data;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCard;
import org.rockhopper.smarthome.wes.jwes.model.data.type.BSSW;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;
import org.rockhopper.smarthome.wes.jwes.model.data.type.VirtualField;

public class WesRelaysCards
extends Field<BSSW, Byte>
implements VirtualField {
    public static final byte MAX_RELAYSCARD = 10;
    @XStreamImplicit(itemFieldName="card")
    private List<WesRelaysCard> cards;

    public WesRelaysCards() {
        this(10, Field.PRIORITY_DISCOVERY);
    }

    public WesRelaysCards(Byte priority) {
        this(10, priority);
    }

    public WesRelaysCards(byte nbCards) {
        this(nbCards, Field.PRIORITY_DISCOVERY);
    }

    public WesRelaysCards(byte nbCards, Byte priority) {
        super(priority);
        for (int i = 0; i < nbCards; ++i) {
            WesRelaysCard relaysCard = new WesRelaysCard((byte)i);
            this.addCard(relaysCard);
        }
    }

    public void addCard(WesRelaysCard relaysCard) {
        if (this.cards == null) {
            this.cards = new ArrayList<WesRelaysCard>(10);
        }
        this.cards.add(relaysCard);
    }

    public Boolean getState(byte cardIndex, byte relayIndex) {
        if (this.cards == null) {
            return null;
        }
        WesRelaysCard relaysCard = this.cards.get(cardIndex);
        return relaysCard != null ? relaysCard.getState(relayIndex) : null;
    }

    public void setState(byte cardIndex, byte relayIndex, Boolean state) {
        if (this.cards == null) {
            return;
        }
        WesRelaysCard relaysCard = this.cards.get(cardIndex);
        if (relaysCard != null) {
            relaysCard.setState(relayIndex, state);
        }
    }

    public Field<BSSW, Byte> getStates() {
        Field<BSSW, Byte> states = null;
        if (this.cards != null) {
            states = new Field<BSSW, Byte>(BSSW.class, Byte.class, Field.PRIORITY_DISCOVERY);
            states.setLabel("data.relaysCards.states");
            states.setValue(new BSSW());
            Iterator<WesRelaysCard> cardsIt = this.cards.iterator();
            int i = 0;
            while (cardsIt.hasNext()) {
                WesRelaysCard relaysCard = cardsIt.next();
                Boolean[] relaysCardStates = relaysCard.getStatesAsBooleanArray();
                for (int j = 1; j <= relaysCardStates.length; ++j) {
                    if (relaysCardStates[j - 1] == null) continue;
                    if (relaysCardStates[j - 1].booleanValue()) {
                        states.getValue().put("rl1" + i + j, (byte)1);
                        continue;
                    }
                    states.getValue().put("rl1" + i + j, (byte)0);
                }
                ++i;
            }
        }
        return states;
    }

    public void setStates(Field<BSSW, Byte> states) {
        BSSW bssw;
        if (states != null && states.getValue() != null && (bssw = states.getValue()).size() > 0) {
            Set keys = bssw.keySet();
            for (String key : keys) {
                if (!key.startsWith("rl1") || key.length() != "rl1ij".length()) continue;
                char[] iCharArray = new char[]{key.charAt(3)};
                char[] jCharArray = new char[]{key.charAt(4)};
                byte i = Byte.valueOf(new String(iCharArray));
                byte j = Byte.valueOf(new String(jCharArray));
                this.setState(i, (byte)(j - 1), (Byte)bssw.get(key) == 1 ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    public List<WesRelaysCard> getCards() {
        return this.cards;
    }

    public void setCards(List<WesRelaysCard> cards) {
        this.cards = cards;
    }

    public void truncateTo(byte byteValue) {
        if (this.cards != null && this.cards.size() > byteValue) {
            this.cards.subList(byteValue, this.cards.size()).clear();
        }
    }

    @Override
    public BSSW getValue() {
        Field<BSSW, Byte> states = this.getStates();
        return states != null ? states.getValue() : null;
    }

    @Override
    public void setValue(BSSW value) {
        if (value != null) {
            Field<BSSW, Byte> states = new Field<BSSW, Byte>(BSSW.class, Byte.class, Field.PRIORITY_DISCOVERY);
            states.setValue(value);
        }
    }

    @Override
    public String getMemberName() {
        return "states";
    }
}

