/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.jwes.model.data;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;

@XStreamAlias(value="sensor")
public class WesSensor {
    public static final byte MAX_SENSORS = 30;
    private byte index;
    private Field<String, Void> id;
    private Field<String, Void> name;
    private Field<String, Void> type;
    private Field<BigDecimal, Void> value;

    public WesSensor(byte index) {
        if (index < 0 || index >= 30) {
            throw new UnsupportedOperationException("WES Sensor index is 0 to 29");
        }
        this.index = index;
        this.id = new Field(Field.PRIORITY_DISCOVERY);
        this.name = new Field(Field.PRIORITY_DISCOVERY);
        this.type = new Field(Field.PRIORITY_DISCOVERY);
        this.value = new Field(BigDecimal.class, Field.PRIORITY_LOW);
    }

    public Field<String, Void> getId() {
        return this.id;
    }

    public String getPrettyId() {
        return this.id != null && this.id.getValue() != null ? StringUtils.deleteWhitespace((String)this.id.getValue()) : null;
    }

    public void setId(Field<String, Void> id) {
        this.id = id;
    }

    public Field<String, Void> getName() {
        return this.name;
    }

    public void setName(Field<String, Void> name) {
        this.name = name;
    }

    public Field<String, Void> getType() {
        return this.type;
    }

    public void setType(Field<String, Void> type) {
        this.type = type;
    }

    public Field<BigDecimal, Void> getValue() {
        return this.value;
    }

    public void setValue(Field<BigDecimal, Void> value) {
        this.value = value;
    }

    public byte getIndex() {
        return this.index;
    }
}

