/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.wes2mqtt;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.rockhopper.smarthome.wes.jwes.WesClient;
import org.rockhopper.smarthome.wes.jwes.WesConstants;
import org.rockhopper.smarthome.wes.jwes.discovery.WesUtils;
import org.rockhopper.smarthome.wes.jwes.model.WesConfig;
import org.rockhopper.smarthome.wes.jwes.model.WesServer;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttWesClient;
import org.rockhopper.smarthome.wes.wes2mqtt.WesClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;

@SpringBootApplication
public class MqttApplication {
    private static final Logger logger = LoggerFactory.getLogger(MqttApplication.class);
    @Autowired
    private WesClientConfig wesConfig;
    @Autowired
    private MqttWesClient mqttWesClient;

    public static void main(String[] args) {
        SpringApplication.run(MqttApplication.class, (String[])args);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void afterSpringStartup() {
        logger.info("Start...");
        if (StringUtils.isNotBlank((String)this.wesConfig.getIpAddress()) && StringUtils.isBlank((String)this.wesConfig.getMacAddress())) {
            logger.info("'IpAddress' is configured but not the 'macAddress', let's get IP address from the device...");
            int tcpPort = this.wesConfig.getTcpPort() != null ? this.wesConfig.getTcpPort().intValue() : WesConstants.DEFAULT_TCP_PORT.intValue();
            String macAddress = WesUtils.getMac((String)this.wesConfig.getIpAddress(), (int)tcpPort);
            this.wesConfig.setMacAddress(macAddress);
        }
        WesServer wesServer = null;
        if (this.wesConfig.getMacAddress() != null) {
            boolean isValidMac = WesUtils.isValid_WES_MACAddress((String)this.wesConfig.getMacAddress());
            if (!isValidMac) {
                logger.warn("MAC Address is invalid! We are discarding the value ['{}']", (Object)this.wesConfig.getMacAddress());
            } else {
                logger.error("MAC Address is ['{}']", (Object)this.wesConfig.getMacAddress());
                wesServer = new WesServer(this.wesConfig.getMacAddress(), (WesConfig)this.wesConfig);
            }
        }
        if (wesServer == null) {
            logger.info("No 'IpAddress' is configured, let's run discovery mode...");
            Map macIpMap = this.discovery();
            if (macIpMap != null && macIpMap.size() == 1) {
                String mac = (String)macIpMap.keySet().iterator().next();
                String ipAddress = (String)macIpMap.get(mac);
                this.wesConfig.setMacAddress(mac);
                this.wesConfig.setIpAddress(ipAddress);
                wesServer = new WesServer(this.wesConfig.getMacAddress(), (WesConfig)this.wesConfig);
            }
        }
        if (wesServer != null) {
            System.out.println(wesServer.getWesData());
            this.mqttWesClient.setWesServer(wesServer);
            this.mqttWesClient.start();
        }
        logger.info("End.");
    }

    private Map<String, String> discovery() {
        logger.info("Start scanning...");
        Map scanResult = new WesClient().scan(this.wesConfig.getDiscoveryInterfaceIPs(), this.wesConfig.getTcpPort(), WesConstants.DEFAULT_HTTP_PORT);
        if (scanResult != null && !scanResult.isEmpty()) {
            String content = scanResult.entrySet().stream().map(e -> "Id:" + (String)e.getKey() + "->IP:" + (String)e.getValue()).collect(Collectors.joining(", "));
            System.out.println("WES found: " + content);
        } else {
            System.out.println("No WES found!");
        }
        logger.info("End of scan.");
        return scanResult;
    }
}

