/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.wes2mqtt;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.rockhopper.smarthome.wes.jwes.model.WesEvent;
import org.rockhopper.smarthome.wes.jwes.model.WesEventListener;
import org.rockhopper.smarthome.wes.jwes.model.WesServer;
import org.rockhopper.smarthome.wes.jwes.model.data.WesData;
import org.rockhopper.smarthome.wes.jwes.model.data.WesOneWireRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCard;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;
import org.rockhopper.smarthome.wes.wes2mqtt.HomeAssistantIntegration;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttConfig;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttPushClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Component
public class MqttWesClient
implements WesEventListener,
MqttCallback,
DisposableBean {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean shutdownInProgress = false;
    @Autowired
    private MqttConfig mqttConfig;
    @Autowired
    private FreeMarkerConfigurer freeMarkerConfigurer;
    @Autowired
    private MqttPushClient mqttPushClient;
    private Map<String, Field<?, ?>> cmndLabels;
    private WesServer wesServer;

    public void start() {
        if (this.wesServer == null) {
            throw new IllegalStateException("MqttWesClient cannot be started without WES Server!");
        }
        this.log.info("{} {}", (Object)this.wesServer.getWesData(), this.wesServer.getWesConfig() != null ? this.wesServer.getWesConfig().getIpAddress() : null);
        Set fields = this.wesServer.label();
        fields.forEach(field -> this.onEvent(new WesEvent(field.getLabel(), WesEvent.WesEventCode.UPDATE, null, field.getValue())));
        WesData wesData = this.wesServer.getWesData();
        this.cmndLabels = new HashMap();
        String cmndTopic = this.mqttConfig.getBaseTopic() + "/" + this.mqttConfig.getCommandSubTopic() + "/";
        this.cmndLabels.put(cmndTopic + this.labelToSubTopic(wesData.getRelay1().getValue().getLabel()), wesData.getRelay1().getValue());
        this.log.info("Adding cmdTopic '{}'", (Object)(cmndTopic + this.labelToSubTopic(wesData.getRelay1().getValue().getLabel())));
        this.cmndLabels.put(cmndTopic + this.labelToSubTopic(wesData.getRelay2().getValue().getLabel()), wesData.getRelay2().getValue());
        this.log.info("Adding cmdTopic '{}'", (Object)(cmndTopic + this.labelToSubTopic(wesData.getRelay2().getValue().getLabel())));
        List relaysCardsLists = wesData.getRelaysCards().getCards();
        if (relaysCardsLists != null && relaysCardsLists.size() > 0) {
            for (WesRelaysCard relaysCard : relaysCardsLists) {
                List oneWireRelaysList = relaysCard.getRelays();
                if (oneWireRelaysList == null || oneWireRelaysList.size() <= 0) continue;
                for (WesOneWireRelay oneWireRelay : oneWireRelaysList) {
                    if (oneWireRelay == null) continue;
                    this.cmndLabels.put(cmndTopic + this.labelToSubTopic(oneWireRelay.getState().getLabel()), oneWireRelay.getState());
                    this.log.info("Adding cmdTopic '{}'", (Object)(cmndTopic + this.labelToSubTopic(oneWireRelay.getState().getLabel())), (Object)oneWireRelay.getState());
                }
            }
        }
        MapUtils.debugPrint((PrintStream)System.out, (Object)"myMap", (Map)this.cmndLabels);
        new HomeAssistantIntegration(this.mqttPushClient, this.freeMarkerConfigurer).fulfillDiscovery(this.wesServer);
        this.mqttPushClient.setCallback((MqttCallback)this);
        this.wesServer.startPolling((WesEventListener)this);
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public void stop() {
        this.shutdownInProgress = true;
        if (this.wesServer != null) {
            this.wesServer.stopPolling();
        }
        if (this.mqttPushClient != null) {
            this.mqttPushClient.close();
        }
    }

    public void onEvent(WesEvent event) {
        if (WesEvent.WesEventCode.UPDATE.equals((Object)event.getEventCode()) || WesEvent.WesEventCode.SYNC.equals((Object)event.getEventCode())) {
            if (this.mqttPushClient != null) {
                if (event.getNewValue() != null) {
                    this.mqttPushClient.publishToSubTopic(0, false, this.labelToSubTopic(event.getFieldLabel()), event.getNewValue().toString());
                } else {
                    this.log.warn("Issue handling WesEvent, the new value for '{}' is null!", (Object)event.getFieldLabel());
                }
            } else {
                this.log.error("mqttPushClient is *NULL*!!!");
            }
        }
    }

    public String labelToSubTopic(String label) {
        if (label == null || label.length() == 0) {
            return label;
        }
        String subTopic = StringUtils.removeStart((String)label, (String)"data.");
        subTopic = StringUtils.replace((String)subTopic, (String)".", (String)"/");
        return subTopic;
    }

    public void connectionLost(Throwable cause) {
        if (!this.shutdownInProgress) {
            this.log.error("Disconnected ({}).", (Object)(cause != null ? cause.getMessage() : null), (Object)cause);
            try {
                this.mqttPushClient.reconnectMqttPushClient();
            }
            catch (Exception e) {
                this.log.error("Exception caught while trying to reconnect to MQTT Server", (Throwable)e);
            }
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        this.log.info("Receive message subject : " + topic);
        this.log.info("receive messages Qos : " + message.getQos());
        this.log.info("Receive message content : " + String.valueOf(message.getPayload()));
        this.log.info("Receive message as String : " + new String(message.getPayload()));
        if (message.getPayload() == null) {
            return;
        }
        String payload = new String(message.getPayload());
        if (this.wesServer != null) {
            Field field = (Field)this.cmndLabels.get(topic);
            if (field == null) {
                this.log.error("No field matching topic '{}'", (Object)topic);
            } else if ("0".equals(payload)) {
                this.log.info("forceUpdate : {} -> {}", (Object)field.getLabel(), (Object)payload);
                this.wesServer.forceUpdate(field, (Object)0);
            } else if ("1".equals(payload)) {
                this.log.info("forceUpdate : {} -> {}", (Object)field.getLabel(), (Object)payload);
                this.wesServer.forceUpdate(field, (Object)1);
            } else {
                this.log.info("forceUpdate : {} -> {}", (Object)field.getLabel(), (Object)payload);
                this.wesServer.forceUpdate(field, (Object)Boolean.valueOf(payload));
            }
        } else {
            this.log.warn("Skipping payload [{}] as there is no WES Server!");
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.log.info("deliveryComplete---------" + token.isComplete());
    }

    public void setWesServer(WesServer wesServer) {
        this.wesServer = wesServer;
    }

    public void destroy() throws Exception {
        this.log.info("MqttWesClient#destroy() is stopping MQTT WES Client!");
        if (!this.shutdownInProgress) {
            this.stop();
        }
    }
}

