/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.wes2mqtt;

import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rockhopper.smarthome.wes.jwes.model.WesServer;
import org.rockhopper.smarthome.wes.jwes.model.data.WesOneWireRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCard;
import org.rockhopper.smarthome.wes.jwes.model.data.WesSensor;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttPushClient;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class HomeAssistantIntegration {
    public static final String HOMEASSISTANT_DISCOVERY_TOPIC_PREFIX = "homeassistant";
    private FreeMarkerConfigurer freeMarkerConfigurer;
    private MqttPushClient mqttPushClient;

    public HomeAssistantIntegration(MqttPushClient mqttPushClient, FreeMarkerConfigurer freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
        this.mqttPushClient = mqttPushClient;
    }

    public void fulfillDiscovery(WesServer wesServer) {
        if (wesServer == null || wesServer.getWesData() == null) {
            return;
        }
        this.registerWesRelaysSwitches(wesServer);
        this.registerWesRelaysCardsRelaySwitches(wesServer);
        this.registerWesSensors(wesServer);
    }

    private void registerWesRelaySwitch(WesServer wesServer, byte relayIdx) {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("wesServer", wesServer);
            WesRelay wesRelay = null;
            if (relayIdx == 1) {
                wesRelay = wesServer.getWesData().getRelay1();
            } else if (relayIdx == 2) {
                wesRelay = wesServer.getWesData().getRelay2();
            } else {
                return;
            }
            values.put("wesRelay", wesRelay);
            String payload = this.generateJsonByTemplate("relay", values);
            this.mqttPushClient.publishToTopic(0, true, String.format("%s/switch/wes_%s/wes_relay%d/config", HOMEASSISTANT_DISCOVERY_TOPIC_PREFIX, wesServer.getMacAddress(), wesRelay.getIndex()), payload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerWesRelaysSwitches(WesServer wesServer) {
        this.registerWesRelaySwitch(wesServer, (byte)1);
        this.registerWesRelaySwitch(wesServer, (byte)2);
    }

    private void registerWesRelaysCardsRelaySwitches(WesServer wesServer) {
        try {
            if (wesServer.getWesData().getRelaysCards() != null && wesServer.getWesData().getRelaysCards().getCards() != null) {
                List wesRelaysCards = wesServer.getWesData().getRelaysCards().getCards();
                for (WesRelaysCard wesRelaysCard : wesRelaysCards) {
                    if (wesRelaysCard == null) continue;
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.put("wesRelaysCard", wesRelaysCard);
                    List oneWireRelays = wesRelaysCard.getRelays();
                    if (oneWireRelays == null) continue;
                    for (WesOneWireRelay oneWireRelay : oneWireRelays) {
                        if (oneWireRelay == null) continue;
                        values.put("oneWireRelay", oneWireRelay);
                        values.put("oneWireRelayIdxMinusOne", oneWireRelay.getIndex() - 1);
                        String payload = this.generateJsonByTemplate("relaysCardsRelay", values);
                        this.mqttPushClient.publishToTopic(0, true, String.format("%s/switch/wes_%s/wes_relay1%d%d/config", HOMEASSISTANT_DISCOVERY_TOPIC_PREFIX, wesServer.getMacAddress(), wesRelaysCard.getIndex(), oneWireRelay.getIndex()), payload);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerWesSensors(WesServer wesServer) {
        try {
            if (wesServer.getWesData().getSensors() != null) {
                List wesSensors = wesServer.getWesData().getSensors();
                for (WesSensor wesSensor : wesSensors) {
                    if (wesSensor == null || wesSensor.getType() == null || wesSensor.getType().getValue() == null) continue;
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.put("wesSensor", wesSensor);
                    values.put("wesSensorIdxPlusOne", wesSensor.getIndex() + 1);
                    String payload = this.generateJsonByTemplate("sensor", values);
                    this.mqttPushClient.publishToTopic(0, true, String.format("%s/sensor/wes_%s/wes_sensor%d/config", HOMEASSISTANT_DISCOVERY_TOPIC_PREFIX, wesServer.getMacAddress(), wesSensor.getIndex() + 1), payload);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String generateJsonByTemplate(String templateName, Map<String, Object> input) throws Exception {
        String sourceCode = null;
        try {
            Template template = this.freeMarkerConfigurer.getConfiguration().getTemplate(templateName + ".ftl");
            StringWriter writer = new StringWriter();
            template.process(input, (Writer)writer);
            sourceCode = writer.toString();
        }
        catch (Exception exception) {
            throw new Exception("Processing failed for template '" + templateName + "' with error: " + exception.getMessage(), exception);
        }
        return sourceCode;
    }
}

