/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.wes2mqtt;

import jakarta.annotation.PostConstruct;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MqttPushClient {
    private static final Logger logger = LoggerFactory.getLogger(MqttPushClient.class);
    protected boolean shutdownInProgress = false;
    private static MqttClient client;
    private MqttCallback storedCallback;
    @Autowired
    private MqttConfig mqttConfig;
    private String statTopic;

    private MqttClient getClient() {
        return client;
    }

    private static void setClient(MqttClient client) {
        MqttPushClient.client = client;
    }

    public void connect(String host, String clientID, String username, String password, String statTopic, int timeout, int keepalive) throws MqttException {
        if (this.shutdownInProgress) {
            throw new MqttException(32102);
        }
        this.statTopic = statTopic;
        logger.info("Connecting to MQTT broker at {} with client ID {}", (Object)host, (Object)clientID);
        client = new MqttClient(host, clientID, (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        options.setUserName(username);
        options.setPassword(password.toCharArray());
        options.setConnectionTimeout(timeout);
        options.setKeepAliveInterval(keepalive);
        options.setAutomaticReconnect(false);
        MqttPushClient.setClient((MqttClient)client);
        if (this.storedCallback != null) {
            client.setCallback(this.storedCallback);
        }
        client.connect(options);
        if (!client.isConnected()) {
            throw new MqttException(3);
        }
        logger.info("Successfully connected to MQTT broker");
    }

    public void close() {
        this.shutdownInProgress = true;
        if (client != null) {
            try {
                if (client.isConnected()) {
                    client.disconnectForcibly();
                }
                client.close();
            }
            catch (MqttException me) {
                logger.warn("Exception caught while closing (MQTT) Client", (Throwable)me);
            }
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.storedCallback = mqttCallback;
        if (client != null) {
            client.setCallback(mqttCallback);
        }
    }

    public void publishToTopic(int qos, boolean retained, String topic, String pushMessage) throws MqttException {
        if (this.shutdownInProgress) {
            throw new MqttException(32102);
        }
        if (client == null || !client.isConnected()) {
            throw new MqttException(32104);
        }
        MqttMessage message = new MqttMessage();
        message.setQos(qos);
        message.setRetained(retained);
        message.setPayload(pushMessage.getBytes());
        MqttTopic mTopic = this.getClient().getTopic(topic);
        if (null == mTopic) {
            logger.error("topic not exist");
            throw new MqttException(32108);
        }
        MqttDeliveryToken token = mTopic.publish(message);
        token.waitForCompletion();
    }

    public void publishToSubTopic(int qos, boolean retained, String subtopic, String pushMessage) throws MqttException {
        this.publishToTopic(qos, retained, this.statTopic + "/" + subtopic, pushMessage);
    }

    public void subscribe(String commandtopic, int qos) {
        logger.info("Start subscribing to topics {}", (Object)commandtopic);
        try {
            this.getClient().subscribe(commandtopic, qos);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void reconnectMqttPushClient() throws MqttException {
        if (this.shutdownInProgress) {
            throw new MqttException(32102);
        }
        logger.info("Attempting MQTT reconnection...");
        logger.debug("hostUrl: {}", (Object)this.mqttConfig.getHostUrl());
        logger.debug("clientID: {}", (Object)this.mqttConfig.getClientId());
        logger.debug("username: {}", (Object)this.mqttConfig.getUsername());
        logger.debug("timeout: {}", (Object)this.mqttConfig.getTimeout());
        logger.debug("keepalive: {}", (Object)this.mqttConfig.getKeepalive());
        if (client != null) {
            try {
                if (client.isConnected()) {
                    client.disconnectForcibly();
                }
                client.close();
            }
            catch (Exception e) {
                logger.warn("Error cleaning up existing MQTT client: {}", (Object)e.getMessage());
            }
        }
        this.connect(this.mqttConfig.getHostUrl(), this.mqttConfig.getClientId(), this.mqttConfig.getUsername(), this.mqttConfig.getPassword(), this.mqttConfig.getBaseTopic() + "/" + this.mqttConfig.getStatSubTopic(), this.mqttConfig.getTimeout(), this.mqttConfig.getKeepalive());
        if (this.storedCallback != null) {
            logger.debug("Restoring MQTT callback after reconnection");
            client.setCallback(this.storedCallback);
        }
        if (!this.isConnected()) {
            throw new MqttException(3);
        }
        this.subscribe(this.mqttConfig.getBaseTopic() + "/" + this.mqttConfig.getCommandSubTopic() + "/#", 0);
        logger.info("MQTT reconnection successful");
    }

    public boolean isConnected() {
        return client != null && client.isConnected();
    }

    public String getConnectionStatus() {
        if (client == null) {
            return "Client not initialized";
        }
        return client.isConnected() ? "Connected" : "Disconnected";
    }

    @PostConstruct
    public void init() {
        try {
            this.reconnectMqttPushClient();
        }
        catch (MqttException e) {
            logger.error("Failed to initialize MQTT connection: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

