/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.wes2mqtt;

import java.util.HashMap;
import java.util.Map;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttPushClient;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttWesClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mqtt"})
public class MqttStatusController {
    @Autowired
    private MqttWesClient mqttWesClient;
    @Autowired
    private MqttPushClient mqttPushClient;

    @GetMapping(value={"/status"})
    public Map<String, Object> getStatus() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("connected", this.mqttPushClient.isConnected());
        status.put("connectionStatus", this.mqttPushClient.getConnectionStatus());
        status.put("isReconnecting", this.mqttWesClient.isReconnecting());
        status.put("reconnectionAttempts", this.mqttWesClient.getReconnectionAttempts());
        status.put("shutdownInProgress", this.mqttWesClient.isShutdownInProgress());
        return status;
    }

    @PostMapping(value={"/reconnect"})
    public Map<String, Object> reconnect() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (this.mqttWesClient.isShutdownInProgress()) {
                result.put("success", false);
                result.put("message", "Cannot reconnect: shutdown in progress");
                return result;
            }
            this.mqttWesClient.resetReconnectionState();
            this.mqttPushClient.reconnectMqttPushClient();
            result.put("success", true);
            result.put("message", "Reconnection successful");
            result.put("connected", this.mqttPushClient.isConnected());
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("message", "Reconnection failed: " + e.getMessage());
            result.put("connected", false);
        }
        return result;
    }

    @PostMapping(value={"/reset"})
    public Map<String, Object> resetReconnectionState() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.mqttWesClient.resetReconnectionState();
        result.put("success", true);
        result.put("message", "Reconnection state reset");
        result.put("reconnectionAttempts", this.mqttWesClient.getReconnectionAttempts());
        result.put("isReconnecting", this.mqttWesClient.isReconnecting());
        return result;
    }

    @PostMapping(value={"/discovery/republish"})
    public Map<String, Object> republishDiscovery() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.mqttWesClient.republishHomeAssistantDiscovery();
            result.put("success", true);
            result.put("message", "Home Assistant discovery messages successfully republished");
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("message", "Failed to republish discovery messages: " + e.getMessage());
        }
        return result;
    }
}

