/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.wes2mqtt;

import jakarta.annotation.PostConstruct;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.rockhopper.smarthome.wes.jwes.model.WesEvent;
import org.rockhopper.smarthome.wes.jwes.model.WesEventListener;
import org.rockhopper.smarthome.wes.jwes.model.WesServer;
import org.rockhopper.smarthome.wes.jwes.model.data.WesData;
import org.rockhopper.smarthome.wes.jwes.model.data.WesOneWireRelay;
import org.rockhopper.smarthome.wes.jwes.model.data.WesRelaysCard;
import org.rockhopper.smarthome.wes.jwes.model.data.type.Field;
import org.rockhopper.smarthome.wes.wes2mqtt.HomeAssistantIntegration;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttConfig;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttPushClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Component
public class MqttWesClient
implements WesEventListener,
MqttCallback,
DisposableBean {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean shutdownInProgress = false;
    private final ScheduledExecutorService reconnectExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "MQTT-Reconnect-Thread");
        t.setDaemon(true);
        return t;
    });
    private ScheduledFuture<?> reconnectTask;
    private final AtomicInteger reconnectAttempts = new AtomicInteger(0);
    private final AtomicBoolean isReconnecting = new AtomicBoolean(false);
    private static final int MAX_RECONNECT_ATTEMPTS = 10;
    private static final long INITIAL_RECONNECT_DELAY_MS = 1000L;
    private static final long MAX_RECONNECT_DELAY_MS = 60000L;
    private static final double BACKOFF_MULTIPLIER = 2.0;
    @Autowired
    private MqttConfig mqttConfig;
    @Autowired
    private FreeMarkerConfigurer freeMarkerConfigurer;
    @Autowired
    private MqttPushClient mqttPushClient;
    private Map<String, Field<?, ?>> cmndLabels;
    private WesServer wesServer;

    public void start() {
        if (this.wesServer == null) {
            throw new IllegalStateException("MqttWesClient cannot be started without WES Server!");
        }
        this.log.info("{} {}", (Object)this.wesServer.getWesData(), this.wesServer.getWesConfig() != null ? this.wesServer.getWesConfig().getIpAddress() : null);
        Set fields = this.wesServer.label();
        fields.forEach(field -> this.onEvent(new WesEvent(field.getLabel(), WesEvent.WesEventCode.UPDATE, null, field.getValue())));
        WesData wesData = this.wesServer.getWesData();
        this.cmndLabels = new HashMap();
        String cmndTopic = this.mqttConfig.getBaseTopic() + "/" + this.mqttConfig.getCommandSubTopic() + "/";
        this.cmndLabels.put(cmndTopic + this.labelToSubTopic(wesData.getRelay1().getValue().getLabel()), wesData.getRelay1().getValue());
        this.log.info("Adding cmdTopic '{}'", (Object)(cmndTopic + this.labelToSubTopic(wesData.getRelay1().getValue().getLabel())));
        this.cmndLabels.put(cmndTopic + this.labelToSubTopic(wesData.getRelay2().getValue().getLabel()), wesData.getRelay2().getValue());
        this.log.info("Adding cmdTopic '{}'", (Object)(cmndTopic + this.labelToSubTopic(wesData.getRelay2().getValue().getLabel())));
        List relaysCardsLists = wesData.getRelaysCards().getCards();
        if (relaysCardsLists != null && relaysCardsLists.size() > 0) {
            for (WesRelaysCard relaysCard : relaysCardsLists) {
                List oneWireRelaysList = relaysCard.getRelays();
                if (oneWireRelaysList == null || oneWireRelaysList.size() <= 0) continue;
                for (WesOneWireRelay oneWireRelay : oneWireRelaysList) {
                    if (oneWireRelay == null) continue;
                    this.cmndLabels.put(cmndTopic + this.labelToSubTopic(oneWireRelay.getState().getLabel()), oneWireRelay.getState());
                    this.log.info("Adding cmdTopic '{}'", (Object)(cmndTopic + this.labelToSubTopic(oneWireRelay.getState().getLabel())), (Object)oneWireRelay.getState());
                }
            }
        }
        MapUtils.debugPrint((PrintStream)System.out, (Object)"myMap", (Map)this.cmndLabels);
        new HomeAssistantIntegration(this.mqttPushClient, this.freeMarkerConfigurer).fulfillDiscovery(this.wesServer);
        this.mqttPushClient.setCallback((MqttCallback)this);
        this.wesServer.startPolling((WesEventListener)this);
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public void stop() {
        this.shutdownInProgress = true;
        this.cancelReconnectTask();
        if (this.wesServer != null) {
            this.wesServer.stopPolling();
        }
        if (this.mqttPushClient != null) {
            this.mqttPushClient.close();
        }
        if (!this.reconnectExecutor.isShutdown()) {
            this.reconnectExecutor.shutdown();
            try {
                if (!this.reconnectExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.reconnectExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.reconnectExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void onEvent(WesEvent event) {
        if (WesEvent.WesEventCode.UPDATE.equals((Object)event.getEventCode()) || WesEvent.WesEventCode.SYNC.equals((Object)event.getEventCode())) {
            if (this.mqttPushClient != null) {
                if (event.getNewValue() != null) {
                    try {
                        this.mqttPushClient.publishToSubTopic(0, false, this.labelToSubTopic(event.getFieldLabel()), event.getNewValue().toString());
                        if (this.reconnectAttempts.get() > 0) {
                            this.resetReconnectionState();
                        }
                    }
                    catch (Exception e) {
                        this.log.warn("Failed to publish MQTT message for event {}: {}", (Object)event.getFieldLabel(), (Object)e.getMessage());
                    }
                } else {
                    this.log.warn("Issue handling WesEvent, the new value for '{}' is null!", (Object)event.getFieldLabel());
                }
            } else {
                this.log.error("mqttPushClient is *NULL*!!!");
            }
        }
    }

    public String labelToSubTopic(String label) {
        if (label == null || label.length() == 0) {
            return label;
        }
        String subTopic = StringUtils.removeStart((String)label, (String)"data.");
        subTopic = StringUtils.replace((String)subTopic, (String)".", (String)"/");
        return subTopic;
    }

    public void connectionLost(Throwable cause) {
        this.log.error("MQTT connection lost! Cause: {}, shutdownInProgress: {}", new Object[]{cause != null ? cause.getMessage() : "Unknown reason", this.shutdownInProgress, cause});
        if (!this.shutdownInProgress) {
            this.log.info("Triggering automatic reconnection due to connection loss");
            this.scheduleReconnect();
        } else {
            this.log.info("Skipping reconnection attempt - shutdown in progress");
        }
    }

    private void scheduleReconnect() {
        if (this.isReconnecting.compareAndSet(false, true)) {
            int currentAttempt = this.reconnectAttempts.incrementAndGet();
            if (currentAttempt > 10) {
                this.log.error("Maximum reconnection attempts ({}) exceeded. Giving up reconnection.", (Object)10);
                this.isReconnecting.set(false);
                return;
            }
            long delay = this.calculateReconnectDelay(currentAttempt);
            this.log.info("Scheduling MQTT reconnection attempt {} in {} ms", (Object)currentAttempt, (Object)delay);
            this.reconnectTask = this.reconnectExecutor.schedule(() -> this.attemptReconnect(), delay, TimeUnit.MILLISECONDS);
        }
    }

    private long calculateReconnectDelay(int attempt) {
        long delay = (long)(1000.0 * Math.pow(2.0, attempt - 1));
        return Math.min(delay, 60000L);
    }

    private void attemptReconnect() {
        if (this.shutdownInProgress) {
            this.log.info("Shutdown in progress, cancelling reconnection attempt");
            this.isReconnecting.set(false);
            return;
        }
        try {
            this.log.info("Attempting MQTT reconnection (attempt {})", (Object)this.reconnectAttempts.get());
            this.mqttPushClient.reconnectMqttPushClient();
            this.log.info("MQTT reconnection successful after {} attempts", (Object)this.reconnectAttempts.get());
            this.reconnectAttempts.set(0);
            this.isReconnecting.set(false);
            if (this.wesServer != null) {
                this.log.info("Re-publishing Home Assistant discovery messages after successful MQTT reconnection");
                try {
                    new HomeAssistantIntegration(this.mqttPushClient, this.freeMarkerConfigurer).fulfillDiscovery(this.wesServer);
                    this.log.info("Home Assistant discovery messages successfully re-published");
                }
                catch (Exception discoveryException) {
                    this.log.warn("Failed to re-publish Home Assistant discovery messages: {}", (Object)discoveryException.getMessage(), (Object)discoveryException);
                }
            }
            if (this.wesServer != null && !this.wesServer.isPolling()) {
                this.log.info("Restarting WES polling after successful MQTT reconnection");
                this.wesServer.startPolling((WesEventListener)this);
            }
        }
        catch (Exception e) {
            this.log.warn("MQTT reconnection attempt {} failed: {}", (Object)this.reconnectAttempts.get(), (Object)e.getMessage());
            this.isReconnecting.set(false);
            if (this.reconnectAttempts.get() < 10) {
                this.scheduleReconnect();
            }
            this.log.error("All reconnection attempts failed. Manual intervention may be required.");
        }
    }

    private void cancelReconnectTask() {
        if (this.reconnectTask != null && !this.reconnectTask.isDone()) {
            this.log.info("Cancelling pending MQTT reconnection task");
            this.reconnectTask.cancel(false);
        }
        this.isReconnecting.set(false);
    }

    public void resetReconnectionState() {
        this.log.info("Resetting MQTT reconnection state");
        this.cancelReconnectTask();
        this.reconnectAttempts.set(0);
        this.isReconnecting.set(false);
    }

    @PostConstruct
    private void startHealthCheck() {
        this.log.info("Starting MQTT health check service");
        this.reconnectExecutor.scheduleWithFixedDelay(() -> this.performHealthCheck(), 10L, 60L, TimeUnit.SECONDS);
    }

    private void performHealthCheck() {
        try {
            boolean isConnected = this.mqttPushClient.isConnected();
            this.log.debug("MQTT Health check: connected={}, isReconnecting={}, attempts={}", new Object[]{isConnected, this.isReconnecting.get(), this.reconnectAttempts.get()});
            if (!isConnected && !this.isReconnecting.get()) {
                if (this.reconnectAttempts.get() >= 10) {
                    this.log.warn("Health check: Max reconnection attempts exceeded. Resetting state and retrying...");
                    this.resetReconnectionState();
                }
                this.log.info("Health check: Triggering reconnection attempt");
                this.scheduleReconnect();
            }
        }
        catch (Exception e) {
            this.log.error("Error during MQTT health check: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean isReconnecting() {
        return this.isReconnecting.get();
    }

    public int getReconnectionAttempts() {
        return this.reconnectAttempts.get();
    }

    public void republishHomeAssistantDiscovery() {
        if (this.wesServer == null) {
            this.log.warn("Cannot republish Home Assistant discovery: WES Server is null");
            return;
        }
        if (!this.mqttPushClient.isConnected()) {
            this.log.warn("Cannot republish Home Assistant discovery: MQTT client is not connected");
            return;
        }
        try {
            this.log.info("Republishing Home Assistant discovery messages");
            new HomeAssistantIntegration(this.mqttPushClient, this.freeMarkerConfigurer).fulfillDiscovery(this.wesServer);
            this.log.info("Home Assistant discovery messages successfully republished");
        }
        catch (Exception e) {
            this.log.error("Failed to republish Home Assistant discovery messages: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to republish Home Assistant discovery messages", e);
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        this.log.info("Receive message subject : " + topic);
        this.log.info("receive messages Qos : " + message.getQos());
        this.log.info("Receive message content : " + String.valueOf(message.getPayload()));
        this.log.info("Receive message as String : " + new String(message.getPayload()));
        if (message.getPayload() == null) {
            return;
        }
        String payload = new String(message.getPayload());
        if (this.wesServer != null) {
            Field field = (Field)this.cmndLabels.get(topic);
            if (field == null) {
                this.log.error("No field matching topic '{}'", (Object)topic);
            } else if ("0".equals(payload)) {
                this.log.info("forceUpdate : {} -> {}", (Object)field.getLabel(), (Object)payload);
                this.wesServer.forceUpdate(field, (Object)0);
            } else if ("1".equals(payload)) {
                this.log.info("forceUpdate : {} -> {}", (Object)field.getLabel(), (Object)payload);
                this.wesServer.forceUpdate(field, (Object)1);
            } else {
                this.log.info("forceUpdate : {} -> {}", (Object)field.getLabel(), (Object)payload);
                this.wesServer.forceUpdate(field, (Object)Boolean.valueOf(payload));
            }
        } else {
            this.log.warn("Skipping payload [{}] as there is no WES Server!");
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.log.info("deliveryComplete---------" + token.isComplete());
    }

    public void setWesServer(WesServer wesServer) {
        this.wesServer = wesServer;
    }

    public void destroy() throws Exception {
        this.log.info("MqttWesClient#destroy() is stopping MQTT WES Client!");
        if (!this.shutdownInProgress) {
            this.stop();
        }
    }
}

