/*
 * Decompiled with CFR 0.152.
 */
package org.rockhopper.smarthome.wes.wes2mqtt;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.rockhopper.smarthome.wes.wes2mqtt.MqttPushClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushCallback
implements MqttCallback {
    private static final Logger logger = LoggerFactory.getLogger(MqttPushClient.class);
    @Autowired
    private MqttPushClient mqttPushClient;
    private static MqttClient client;

    public void connectionLost(Throwable cause) {
        logger.info("Disconnected, can be reconnected");
        if (null != client) {
            try {
                this.mqttPushClient.reconnectMqttPushClient();
            }
            catch (Exception e) {
                logger.error("Failed to reconnect MQTT client: {}", (Object)e.getMessage());
            }
        }
    }

    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        logger.info("Receive message subject : " + topic);
        logger.info("receive messages Qos : " + mqttMessage.getQos());
        logger.info("Receive message content : " + new String(mqttMessage.getPayload()));
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        logger.info("deliveryComplete---------" + iMqttDeliveryToken.isComplete());
    }
}

