/*
 * Decompiled with CFR 0.152.
 */
package org.rometools.fetcher.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.rometools.fetcher.impl.FeedFetcherCache;
import org.rometools.fetcher.impl.SyndFeedInfo;

public class DiskFeedInfoCache
implements FeedFetcherCache {
    protected String cachePath = null;

    public DiskFeedInfoCache(String cachePath) {
        this.cachePath = cachePath;
    }

    public SyndFeedInfo getFeedInfo(URL url) {
        SyndFeedInfo info = null;
        String fileName = this.cachePath + File.separator + "feed_" + DiskFeedInfoCache.replaceNonAlphanumeric(url.toString(), '_').trim();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            info = (SyndFeedInfo)ois.readObject();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Attempting to read from cache", cnfe);
        }
        catch (IOException fnfe) {
            throw new RuntimeException("Attempting to read from cache", fnfe);
        }
        return info;
    }

    public void setFeedInfo(URL url, SyndFeedInfo feedInfo) {
        String fileName = this.cachePath + File.separator + "feed_" + DiskFeedInfoCache.replaceNonAlphanumeric(url.toString(), '_').trim();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(feedInfo);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Attempting to write to cache", e);
        }
    }

    public static String replaceNonAlphanumeric(String str, char subst) {
        StringBuffer ret = new StringBuffer(str.length());
        char[] testChars = str.toCharArray();
        for (int i = 0; i < testChars.length; ++i) {
            if (Character.isLetterOrDigit(testChars[i])) {
                ret.append(testChars[i]);
                continue;
            }
            ret.append(subst);
        }
        return ret.toString();
    }

    public synchronized void clear() {
        File file = new File(this.cachePath);
        if (file.exists() && file.canWrite()) {
            String[] files = file.list();
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                File deleteMe = new File(this.cachePath + File.separator + files[i]);
                deleteMe.delete();
            }
        }
    }

    public SyndFeedInfo remove(URL url) {
        SyndFeedInfo info = null;
        String fileName = this.cachePath + File.separator + "feed_" + DiskFeedInfoCache.replaceNonAlphanumeric(url.toString(), '_').trim();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            info = (SyndFeedInfo)ois.readObject();
            fis.close();
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Attempting to read from cache", cnfe);
        }
        catch (IOException fnfe) {
            throw new RuntimeException("Attempting to read from cache", fnfe);
        }
        return info;
    }
}

