/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.base.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.base.GoogleBaseImpl;
import com.sun.syndication.feed.module.base.io.GoogleBaseParser;
import com.sun.syndication.feed.module.base.types.CurrencyEnumeration;
import com.sun.syndication.feed.module.base.types.DateTimeRange;
import com.sun.syndication.feed.module.base.types.FloatUnit;
import com.sun.syndication.feed.module.base.types.GenderEnumeration;
import com.sun.syndication.feed.module.base.types.IntUnit;
import com.sun.syndication.feed.module.base.types.PaymentTypeEnumeration;
import com.sun.syndication.feed.module.base.types.PriceTypeEnumeration;
import com.sun.syndication.feed.module.base.types.ShippingType;
import com.sun.syndication.feed.module.base.types.ShortDate;
import com.sun.syndication.feed.module.base.types.Size;
import com.sun.syndication.feed.module.base.types.YearType;
import com.sun.syndication.io.ModuleGenerator;
import java.beans.PropertyDescriptor;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class GoogleBaseGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"g-core", (String)"http://base.google.com/ns/1.0");

    public String getNamespaceUri() {
        return "http://base.google.com/ns/1.0";
    }

    public Set getNamespaces() {
        HashSet<Namespace> set = new HashSet<Namespace>();
        set.add(NS);
        return set;
    }

    public void generate(Module module, Element element) {
        GoogleBaseImpl mod = (GoogleBaseImpl)module;
        HashMap<Object, Object> props2tags = new HashMap<Object, Object>(GoogleBaseParser.PROPS2TAGS);
        PropertyDescriptor[] pds = GoogleBaseParser.pds;
        for (int i = 0; i < pds.length; ++i) {
            String tagName = (String)props2tags.get(pds[i].getName());
            if (tagName == null) continue;
            Object[] values = null;
            try {
                values = pds[i].getPropertyType().isArray() ? (Object[])pds[i].getReadMethod().invoke((Object)mod, (Object[])null) : new Object[]{pds[i].getReadMethod().invoke((Object)mod, (Object[])null)};
                for (int j = 0; values != null && j < values.length; ++j) {
                    if (values[j] == null) continue;
                    element.addContent((Content)this.generateTag(values[j], tagName));
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Element generateTag(Object o, String tagName) {
        if (o instanceof URL || o instanceof Float || o instanceof Boolean || o instanceof Integer || o instanceof String || o instanceof FloatUnit || o instanceof IntUnit || o instanceof GenderEnumeration || o instanceof PaymentTypeEnumeration || o instanceof PriceTypeEnumeration || o instanceof CurrencyEnumeration || o instanceof Size || o instanceof YearType) {
            return this.generateSimpleElement(tagName, o.toString());
        }
        if (o instanceof ShortDate) {
            return this.generateSimpleElement(tagName, GoogleBaseParser.SHORT_DT_FMT.format(o));
        }
        if (o instanceof Date) {
            return this.generateSimpleElement(tagName, GoogleBaseParser.LONG_DT_FMT.format(o));
        }
        if (o instanceof ShippingType) {
            ShippingType st = (ShippingType)o;
            Element element = new Element(tagName, NS);
            element.addContent((Content)this.generateSimpleElement("country", st.getCountry()));
            element.addContent((Content)this.generateSimpleElement("service", st.getService().toString()));
            element.addContent((Content)this.generateSimpleElement("price", st.getPrice().toString()));
            return element;
        }
        if (o instanceof DateTimeRange) {
            DateTimeRange dtr = (DateTimeRange)o;
            Element element = new Element(tagName, NS);
            element.addContent((Content)this.generateSimpleElement("start", GoogleBaseParser.LONG_DT_FMT.format(dtr.getStart())));
            element.addContent((Content)this.generateSimpleElement("end", GoogleBaseParser.LONG_DT_FMT.format(dtr.getEnd())));
            return element;
        }
        throw new RuntimeException("Unknown class type to handle: " + o.getClass().getName());
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }
}

