/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.opml.Opml;
import com.sun.syndication.feed.opml.Outline;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedParser;
import com.sun.syndication.io.impl.BaseWireFeedParser;
import com.sun.syndication.io.impl.DateParser;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class OPML10Parser
extends BaseWireFeedParser
implements WireFeedParser {
    private static Logger LOG = Logger.getLogger(OPML10Parser.class.getName());

    public OPML10Parser() {
        super("opml_1.0", null);
    }

    public OPML10Parser(String type) {
        super(type, null);
    }

    public boolean isMyType(Document document) {
        Element e = document.getRootElement();
        return !(!e.getName().equals("opml") || e.getChild("head") != null && e.getChild("head").getChild("docs") != null || e.getAttributeValue("version") != null && !e.getAttributeValue("version").equals("1.0"));
    }

    public WireFeed parse(Document document, boolean validate) throws IllegalArgumentException, FeedException {
        Element root;
        Opml opml;
        block19: {
            Element head;
            block18: {
                block17: {
                    block16: {
                        block15: {
                            opml = new Opml();
                            opml.setFeedType("opml_1.0");
                            root = document.getRootElement();
                            head = root.getChild("head");
                            if (head != null) {
                                opml.setTitle(head.getChildText("title"));
                                if (head.getChildText("dateCreated") != null) {
                                    opml.setCreated(DateParser.parseRFC822((String)head.getChildText("dateCreated")));
                                }
                                if (head.getChildText("dateModified") != null) {
                                    opml.setModified(DateParser.parseRFC822((String)head.getChildText("dateModified")));
                                }
                                opml.setOwnerName(head.getChildTextTrim("ownerName"));
                                opml.setOwnerEmail(head.getChildTextTrim("ownerEmail"));
                                opml.setVerticalScrollState(this.readInteger(head.getChildText("vertScrollState")));
                            }
                            try {
                                opml.setWindowBottom(this.readInteger(head.getChildText("windowBottom")));
                            }
                            catch (NumberFormatException nfe) {
                                LOG.log(Level.WARNING, "Unable to parse windowBottom", nfe);
                                if (!validate) break block15;
                                throw new FeedException("Unable to parse windowBottom", (Throwable)nfe);
                            }
                        }
                        try {
                            opml.setWindowLeft(this.readInteger(head.getChildText("windowLeft")));
                        }
                        catch (NumberFormatException nfe) {
                            LOG.log(Level.WARNING, "Unable to parse windowLeft", nfe);
                        }
                        try {
                            opml.setWindowRight(this.readInteger(head.getChildText("windowRight")));
                        }
                        catch (NumberFormatException nfe) {
                            LOG.log(Level.WARNING, "Unable to parse windowRight", nfe);
                            if (!validate) break block16;
                            throw new FeedException("Unable to parse windowRight", (Throwable)nfe);
                        }
                    }
                    try {
                        opml.setWindowLeft(this.readInteger(head.getChildText("windowLeft")));
                    }
                    catch (NumberFormatException nfe) {
                        LOG.log(Level.WARNING, "Unable to parse windowLeft", nfe);
                        if (!validate) break block17;
                        throw new FeedException("Unable to parse windowLeft", (Throwable)nfe);
                    }
                }
                try {
                    opml.setWindowTop(this.readInteger(head.getChildText("windowTop")));
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.WARNING, "Unable to parse windowTop", nfe);
                    if (!validate) break block18;
                    throw new FeedException("Unable to parse windowTop", (Throwable)nfe);
                }
            }
            try {
                opml.setExpansionState(this.readIntArray(head.getChildText("expansionState")));
            }
            catch (NumberFormatException nfe) {
                LOG.log(Level.WARNING, "Unable to parse expansionState", nfe);
                if (!validate) break block19;
                throw new FeedException("Unable to parse expansionState", (Throwable)nfe);
            }
        }
        opml.setOutlines(this.parseOutlines(root.getChild("body").getChildren("outline"), validate));
        opml.setModules(this.parseFeedModules(root));
        return opml;
    }

    protected Outline parseOutline(Element e, boolean validate) throws FeedException {
        Outline outline;
        block7: {
            block6: {
                if (!e.getName().equals("outline")) {
                    throw new RuntimeException("Not an outline element.");
                }
                outline = new Outline();
                outline.setText(e.getAttributeValue("text"));
                outline.setType(e.getAttributeValue("type"));
                outline.setTitle(e.getAttributeValue("title"));
                List jAttributes = e.getAttributes();
                ArrayList<com.sun.syndication.feed.opml.Attribute> attributes = new ArrayList<com.sun.syndication.feed.opml.Attribute>();
                for (int i = 0; i < jAttributes.size(); ++i) {
                    Attribute a = (Attribute)jAttributes.get(i);
                    if (a.getName().equals("isBreakpoint") || a.getName().equals("isComment") || a.getName().equals("title") || a.getName().equals("text") || a.getName().equals("type")) continue;
                    attributes.add(new com.sun.syndication.feed.opml.Attribute(a.getName(), a.getValue()));
                }
                outline.setAttributes(attributes);
                try {
                    outline.setBreakpoint(this.readBoolean(e.getAttributeValue("isBreakpoint")));
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Unable to parse isBreakpoint value", ex);
                    if (!validate) break block6;
                    throw new FeedException("Unable to parse isBreakpoint value", (Throwable)ex);
                }
            }
            try {
                outline.setComment(this.readBoolean(e.getAttributeValue("isComment")));
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Unable to parse isComment value", ex);
                if (!validate) break block7;
                throw new FeedException("Unable to parse isComment value", (Throwable)ex);
            }
        }
        List children = e.getChildren("outline");
        outline.setModules(this.parseItemModules(e));
        outline.setChildren(this.parseOutlines(children, validate));
        return outline;
    }

    protected List parseOutlines(List elements, boolean validate) throws FeedException {
        ArrayList<Outline> results = new ArrayList<Outline>();
        for (int i = 0; i < elements.size(); ++i) {
            results.add(this.parseOutline((Element)elements.get(i), validate));
        }
        return results;
    }

    protected boolean readBoolean(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.getBoolean(value.trim());
    }

    protected int[] readIntArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(value, ",");
        int[] result = new int[tok.countTokens()];
        int count = 0;
        while (tok.hasMoreElements()) {
            result[count] = Integer.parseInt(tok.nextToken().trim());
            ++count;
        }
        return result;
    }

    protected Integer readInteger(String value) {
        if (value != null) {
            return new Integer(value);
        }
        return null;
    }
}

