/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.opml.Attribute;
import com.sun.syndication.feed.opml.Opml;
import com.sun.syndication.feed.opml.Outline;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.impl.DateParser;
import com.sun.syndication.io.impl.OPML10Parser;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class OPML20Parser
extends OPML10Parser {
    public OPML20Parser() {
        super("opml_2.0");
    }

    public boolean isMyType(Document document) {
        Element e = document.getRootElement();
        return e.getName().equals("opml") && (e.getChild("head") != null && e.getChild("head").getChild("docs") != null || e.getAttributeValue("version") != null && e.getAttributeValue("version").equals("2.0") || e.getChild("head") != null && e.getChild("head").getChild("ownerId") != null);
    }

    public WireFeed parse(Document document, boolean validate) throws IllegalArgumentException, FeedException {
        Opml opml = (Opml)super.parse(document, validate);
        Element head = document.getRootElement().getChild("head");
        if (head != null) {
            opml.setOwnerId(head.getChildTextTrim("ownerId"));
            opml.setDocs(head.getChildTextTrim("docs"));
            if (opml.getDocs() == null) {
                opml.setDocs("http://www.opml.org/spec2");
            }
        }
        opml.setFeedType("opml_2.0");
        return opml;
    }

    protected Outline parseOutline(Element e, boolean validate) throws FeedException {
        Outline retValue = super.parseOutline(e, validate);
        if (e.getAttributeValue("created") != null) {
            retValue.setCreated(DateParser.parseRFC822((String)e.getAttributeValue("created")));
        }
        List atts = retValue.getAttributes();
        for (int i = 0; i < atts.size(); ++i) {
            Attribute a = (Attribute)atts.get(i);
            if (!a.getName().equals("created")) continue;
            retValue.getAttributes().remove(a);
            break;
        }
        return retValue;
    }
}

