/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Optional;
import org.rootservices.jwt.entity.jwt.Claims;
import org.rootservices.jwt.entity.jwt.Token;
import org.rootservices.jwt.entity.jwt.header.Header;
import org.rootservices.jwt.serializer.JWTSerializer;
import org.rootservices.jwt.serializer.Serializer;

public class JWTSerializerImpl
implements JWTSerializer {
    private final int SECURE_TOKEN_LENGTH = 3;
    private Serializer serializer;
    private Base64.Encoder encoder;
    private Base64.Decoder decoder;

    public JWTSerializerImpl(Serializer serializer, Base64.Encoder encoder, Base64.Decoder decoder) {
        this.serializer = serializer;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public String tokenToJwt(Token token) {
        String jwt = "";
        String headerJson = "";
        String claimsJson = "";
        try {
            headerJson = this.serializer.objectToJson(token.getHeader());
            claimsJson = this.serializer.objectToJson(token.getClaims());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        jwt = this.encode(headerJson) + "." + this.encode(claimsJson) + ".";
        if (token.getSignature().isPresent()) {
            jwt = jwt + token.getSignature().get();
        }
        return jwt;
    }

    private String encode(String input) {
        return this.encoder.encodeToString(input.getBytes(Charset.forName("UTF-8")));
    }

    @Override
    public Token jwtToToken(String jwt, Class claimClass) {
        String[] jwtParts = jwt.split("\\.");
        byte[] headerJson = this.decoder.decode(jwtParts[0]);
        byte[] claimsJson = this.decoder.decode(jwtParts[1]);
        Header header = (Header)this.serializer.jsonBytesToObject(headerJson, Header.class);
        Claims claim = (Claims)this.serializer.jsonBytesToObject(claimsJson, claimClass);
        Token token = new Token(header, claim, Optional.of(jwt));
        if (jwtParts.length == 3 && jwtParts[2] != null) {
            token.setSignature(Optional.of(jwtParts[2]));
        }
        return token;
    }
}

