/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.signature.signer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.crypto.Mac;
import org.rootservices.jwt.entity.jwt.Token;
import org.rootservices.jwt.serializer.Serializer;
import org.rootservices.jwt.signature.signer.Signer;

public class MacSignerImpl
implements Signer {
    private Serializer serializer;
    private Mac mac;
    private Base64.Encoder encoder;

    public MacSignerImpl(Serializer serializer, Mac mac, Base64.Encoder encoder) {
        this.serializer = serializer;
        this.mac = mac;
        this.encoder = encoder;
    }

    @Override
    public String run(Token token) {
        String headerJson = "";
        String claimsJson = "";
        try {
            headerJson = this.serializer.objectToJson(token.getHeader());
            claimsJson = this.serializer.objectToJson(token.getClaims());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        String signInput = this.encode(headerJson) + "." + this.encode(claimsJson);
        return this.sign(signInput.getBytes());
    }

    @Override
    public String run(byte[] input) {
        return this.sign(input);
    }

    private String sign(byte[] input) {
        byte[] signature = this.mac.doFinal(input);
        return this.encode(signature);
    }

    private String encode(String input) {
        return this.encode(input.getBytes(Charset.forName("UTF-8")));
    }

    private String encode(byte[] input) {
        return this.encoder.encodeToString(input);
    }
}

