/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.signature.signer.factory;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.rootservices.jwt.entity.jwk.Key;
import org.rootservices.jwt.entity.jwk.KeyType;
import org.rootservices.jwt.entity.jwt.header.Algorithm;
import org.rootservices.jwt.signature.signer.SignAlgorithm;
import org.rootservices.jwt.signature.signer.factory.MacFactory;

public class MacFactoryImpl
implements MacFactory {
    @Override
    public java.security.Key makeKey(Algorithm alg, Key jwk) {
        SecretKeySpec key = null;
        if (alg == Algorithm.HS256 && jwk.getKeyType() == KeyType.OCT) {
            byte[] secretKey = Base64.getUrlDecoder().decode(jwk.getKey());
            key = new SecretKeySpec(secretKey, SignAlgorithm.HS256.getValue());
        }
        return key;
    }

    @Override
    public Mac makeMac(Algorithm alg, Key jwk) {
        java.security.Key securityKey = this.makeKey(alg, jwk);
        Mac mac = null;
        try {
            mac = Mac.getInstance(securityKey.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            mac.init(securityKey);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return mac;
    }
}

