/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.signature.signer.factory;

import java.util.Base64;
import javax.crypto.Mac;
import org.rootservices.jwt.entity.jwk.Key;
import org.rootservices.jwt.entity.jwt.header.Algorithm;
import org.rootservices.jwt.serializer.Serializer;
import org.rootservices.jwt.signature.signer.MacSignerImpl;
import org.rootservices.jwt.signature.signer.Signer;
import org.rootservices.jwt.signature.signer.factory.MacFactory;
import org.rootservices.jwt.signature.signer.factory.SignerFactory;

public class SignerFactoryImpl
implements SignerFactory {
    private MacFactory macFactory;
    private Serializer serializer;
    private Base64.Encoder encoder;

    public SignerFactoryImpl(MacFactory macFactory, Serializer serializer, Base64.Encoder encoder) {
        this.macFactory = macFactory;
        this.serializer = serializer;
        this.encoder = encoder;
    }

    @Override
    public Signer makeSigner(Algorithm alg, Key jwk) {
        Mac mac = this.macFactory.makeMac(alg, jwk);
        MacSignerImpl signer = new MacSignerImpl(this.serializer, mac, this.encoder);
        return signer;
    }
}

