/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.rootservices.jwt.SecureJwtEncoder;
import org.rootservices.jwt.UnSecureJwtEncoder;
import org.rootservices.jwt.entity.jwk.Key;
import org.rootservices.jwt.entity.jwt.header.Algorithm;
import org.rootservices.jwt.factory.SecureJwtFactory;
import org.rootservices.jwt.factory.UnSecureJwtFactory;
import org.rootservices.jwt.serializer.JWTSerializer;
import org.rootservices.jwt.serializer.Serializer;
import org.rootservices.jwt.signature.signer.Signer;
import org.rootservices.jwt.signature.signer.factory.SignerFactory;
import org.rootservices.jwt.signature.signer.factory.exception.InvalidAlgorithmException;
import org.rootservices.jwt.signature.signer.factory.exception.InvalidJsonWebKeyException;
import org.rootservices.jwt.signature.signer.factory.hmac.MacFactory;
import org.rootservices.jwt.signature.signer.factory.rsa.PrivateKeySignatureFactory;
import org.rootservices.jwt.signature.signer.factory.rsa.PublicKeySignatureFactory;
import org.rootservices.jwt.signature.verifier.VerifySignature;
import org.rootservices.jwt.signature.verifier.factory.VerifySignatureFactory;
import org.rootservices.jwt.translator.CSRToRSAPublicKey;
import org.rootservices.jwt.translator.PemToRSAKeyPair;

public class AppFactory {
    public ObjectMapper objectMapper() {
        return new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public Serializer serializer() {
        return new Serializer(this.objectMapper());
    }

    public Base64.Decoder decoder() {
        return Base64.getDecoder();
    }

    public Base64.Decoder urlDecoder() {
        return Base64.getUrlDecoder();
    }

    public Base64.Encoder encoder() {
        return Base64.getUrlEncoder().withoutPadding();
    }

    public JWTSerializer jwtSerializer() {
        return new JWTSerializer(this.serializer(), this.encoder(), this.decoder());
    }

    public PublicKeySignatureFactory publicKeySignatureFactory() {
        return new PublicKeySignatureFactory(this.rsaKeyFactory());
    }

    public MacFactory macFactory() {
        return new MacFactory(this.urlDecoder());
    }

    public PrivateKeySignatureFactory privateKeySignatureFactory() {
        return new PrivateKeySignatureFactory(this.rsaKeyFactory());
    }

    public SignerFactory signerFactory() {
        return new SignerFactory(this.macFactory(), this.privateKeySignatureFactory(), this.jwtSerializer(), this.encoder());
    }

    public VerifySignatureFactory verifySignatureFactory() {
        return new VerifySignatureFactory(this.signerFactory(), this.publicKeySignatureFactory(), this.urlDecoder());
    }

    public VerifySignature verifySignature(Algorithm algorithm, Key key) throws InvalidAlgorithmException, InvalidJsonWebKeyException {
        return this.verifySignatureFactory().makeVerifySignature(algorithm, key);
    }

    public UnSecureJwtFactory unsecureJwtFactory() {
        return new UnSecureJwtFactory();
    }

    public SecureJwtFactory secureJwtFactory(Algorithm alg, Key jwk) throws InvalidAlgorithmException, InvalidJsonWebKeyException {
        Signer signer = this.signerFactory().makeSigner(alg, jwk);
        return new SecureJwtFactory(signer, alg, jwk.getKeyId());
    }

    public SecureJwtEncoder secureJwtEncoder(Algorithm alg, Key jwk) throws InvalidAlgorithmException, InvalidJsonWebKeyException {
        SecureJwtFactory secureJwtFactory = null;
        try {
            secureJwtFactory = this.secureJwtFactory(alg, jwk);
        }
        catch (InvalidAlgorithmException e) {
            throw e;
        }
        catch (InvalidJsonWebKeyException e) {
            throw e;
        }
        JWTSerializer jwtSerializer = this.jwtSerializer();
        return new SecureJwtEncoder(secureJwtFactory, jwtSerializer);
    }

    public UnSecureJwtEncoder unSecureJwtEncoder() {
        return new UnSecureJwtEncoder(this.unsecureJwtFactory(), this.jwtSerializer());
    }

    public JcaPEMKeyConverter jcaPEMKeyConverter() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return new JcaPEMKeyConverter().setProvider("BC");
    }

    protected KeyFactory rsaKeyFactory() {
        KeyFactory RSAKeyFactory = null;
        try {
            RSAKeyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return RSAKeyFactory;
    }

    public PemToRSAKeyPair pemToRSAKeyPair() {
        return new PemToRSAKeyPair(this.jcaPEMKeyConverter(), this.rsaKeyFactory());
    }

    public CSRToRSAPublicKey csrToRSAPublicKey() {
        return new CSRToRSAPublicKey();
    }
}

