/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.serializer;

import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Optional;
import org.rootservices.jwt.entity.jwt.Claims;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.entity.jwt.header.Header;
import org.rootservices.jwt.serializer.Serializer;
import org.rootservices.jwt.serializer.exception.JsonException;
import org.rootservices.jwt.serializer.exception.JsonToJwtException;
import org.rootservices.jwt.serializer.exception.JwtToJsonException;

public class JWTSerializer {
    private final int SECURE_TOKEN_LENGTH = 3;
    private Serializer serializer;
    private Base64.Encoder encoder;
    private Base64.Decoder decoder;
    private final String DELIMITTER = ".";

    public JWTSerializer(Serializer serializer, Base64.Encoder encoder, Base64.Decoder decoder) {
        this.serializer = serializer;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public String makeSignInput(Header header, Claims claims) throws JwtToJsonException {
        String headerJson = "";
        String claimsJson = "";
        try {
            headerJson = this.serializer.objectToJson(header);
            claimsJson = this.serializer.objectToJson(claims);
        }
        catch (JsonException e) {
            throw new JwtToJsonException("Could not make sign input", e);
        }
        return this.encode(headerJson) + "." + this.encode(claimsJson);
    }

    public String jwtToString(JsonWebToken jwt) throws JwtToJsonException {
        String jwtAsText = this.makeSignInput(jwt.getHeader(), jwt.getClaims()) + ".";
        if (jwt.getSignature().isPresent()) {
            jwtAsText = jwtAsText + jwt.getSignature().get();
        }
        return jwtAsText;
    }

    private String encode(String input) {
        return this.encoder.encodeToString(input.getBytes(Charset.forName("UTF-8")));
    }

    public JsonWebToken stringToJwt(String jwtAsText, Class claimClass) throws JsonToJwtException {
        String[] jwtParts = jwtAsText.split("\\.");
        byte[] headerJson = this.decoder.decode(jwtParts[0]);
        byte[] claimsJson = this.decoder.decode(jwtParts[1]);
        Header header = null;
        Claims claim = null;
        try {
            header = (Header)this.serializer.jsonBytesToObject(headerJson, Header.class);
            claim = (Claims)this.serializer.jsonBytesToObject(claimsJson, claimClass);
        }
        catch (JsonException e) {
            throw new JsonToJwtException("JWT json is invalid", e);
        }
        JsonWebToken jwt = new JsonWebToken(header, claim, Optional.of(jwtAsText));
        if (jwtParts.length == 3 && jwtParts[2] != null) {
            jwt.setSignature(Optional.of(jwtParts[2]));
        }
        return jwt;
    }
}

