/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.rootservices.jwt.serializer.exception.JsonException;

public class Serializer {
    private ObjectMapper objectMapper;

    public Serializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String objectToJson(Object object) throws JsonException {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Could not create json from " + object.toString(), e);
        }
    }

    public Object jsonBytesToObject(byte[] json, Class<?> c) throws JsonException {
        Object object = null;
        try {
            object = this.objectMapper.readValue(json, c);
        }
        catch (IOException e) {
            throw new JsonException("Could not create " + c.toString() + " from json byes, " + json.toString(), e);
        }
        return object;
    }
}

