/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.signature.signer;

import java.nio.charset.Charset;
import java.util.Base64;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.serializer.JWTSerializer;
import org.rootservices.jwt.serializer.exception.JwtToJsonException;

public abstract class Signer {
    private JWTSerializer jwtSerializer;
    private Base64.Encoder encoder;

    public Signer(JWTSerializer jwtSerializer, Base64.Encoder encoder) {
        this.jwtSerializer = jwtSerializer;
        this.encoder = encoder;
    }

    private String encode(String input) {
        return this.encode(input.getBytes(Charset.forName("UTF-8")));
    }

    public String run(JsonWebToken jwt) throws JwtToJsonException {
        String signInput = this.jwtSerializer.makeSignInput(jwt.getHeader(), jwt.getClaims());
        return this.run(signInput.getBytes());
    }

    protected String encode(byte[] input) {
        return this.encoder.encodeToString(input);
    }

    public abstract String run(byte[] var1);
}

