/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.signature.signer.factory.rsa;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.rootservices.jwt.entity.jwk.RSAPublicKey;
import org.rootservices.jwt.signature.signer.SignAlgorithm;
import org.rootservices.jwt.signature.signer.factory.exception.InvalidAlgorithmException;
import org.rootservices.jwt.signature.signer.factory.rsa.exception.PublicKeyException;
import org.rootservices.jwt.signature.signer.factory.rsa.exception.RSAPublicKeyException;

public class PublicKeySignatureFactory {
    private KeyFactory RSAKeyFactory;

    public PublicKeySignatureFactory(KeyFactory RSAKeyFactory) {
        this.RSAKeyFactory = RSAKeyFactory;
    }

    public java.security.interfaces.RSAPublicKey makePublicKey(RSAPublicKey jwk) throws PublicKeyException {
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(jwk.getN(), jwk.getE());
        java.security.interfaces.RSAPublicKey publicKey = null;
        try {
            publicKey = (java.security.interfaces.RSAPublicKey)this.RSAKeyFactory.generatePublic(rsaPublicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new PublicKeyException("Could not make java.security.interfaces.RSAPublicKey", e);
        }
        return publicKey;
    }

    public Signature makeSignature(SignAlgorithm alg, RSAPublicKey jwk) throws PublicKeyException, InvalidAlgorithmException, RSAPublicKeyException {
        java.security.interfaces.RSAPublicKey securityPublicKey = this.makePublicKey(jwk);
        Signature signature = null;
        try {
            signature = Signature.getInstance(alg.getJdkAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmException("Could not create Signature", e);
        }
        try {
            signature.initVerify(securityPublicKey);
        }
        catch (InvalidKeyException e) {
            throw new RSAPublicKeyException("Failed adding key to Signature", e);
        }
        return signature;
    }
}

