/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.builder.compact;

import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rootservices.jwt.builder.exception.CompactException;
import org.rootservices.jwt.config.JwtAppFactory;
import org.rootservices.jwt.entity.jwe.EncryptionAlgorithm;
import org.rootservices.jwt.entity.jwk.RSAPublicKey;
import org.rootservices.jwt.entity.jwk.SymmetricKey;
import org.rootservices.jwt.entity.jwt.header.Algorithm;
import org.rootservices.jwt.entity.jwt.header.Header;
import org.rootservices.jwt.jwe.entity.JWE;
import org.rootservices.jwt.jwe.factory.exception.CipherException;
import org.rootservices.jwt.jwe.serialization.JweSerializer;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.PublicKeyException;
import org.rootservices.jwt.serialization.exception.EncryptException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;

public class EncryptedCompactBuilder {
    private static final Logger LOGGER = LogManager.getLogger(EncryptedCompactBuilder.class);
    public static final String UNABLE_TO_BUILD_COMPACT_JWE = "Unable to build compact jwe";
    private static JwtAppFactory jwtAppFactory = new JwtAppFactory();
    private byte[] payload;
    private SymmetricKey cek;
    private Algorithm alg;
    private EncryptionAlgorithm encAlg;
    private RSAPublicKey publicKey;

    public EncryptedCompactBuilder payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public EncryptedCompactBuilder rsa(RSAPublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public EncryptedCompactBuilder cek(SymmetricKey cek) {
        this.cek = cek;
        return this;
    }

    public EncryptedCompactBuilder alg(Algorithm alg) {
        this.alg = alg;
        return this;
    }

    public EncryptedCompactBuilder encAlg(EncryptionAlgorithm encAlg) {
        this.encAlg = encAlg;
        return this;
    }

    public ByteArrayOutputStream build() throws CompactException {
        JWE jwe = this.jwe();
        JweSerializer jweSerializer = this.jweSerializer();
        try {
            return jweSerializer.JWEToCompact(jwe);
        }
        catch (CipherException | EncryptException | JsonToJwtException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CompactException(UNABLE_TO_BUILD_COMPACT_JWE, e);
        }
    }

    protected JweSerializer jweSerializer() throws CompactException {
        JweSerializer jweSerializer = this.publicKey != null ? this.jweRsaSerializer() : jwtAppFactory.jweDirectSerializer();
        return jweSerializer;
    }

    protected JweSerializer jweRsaSerializer() throws CompactException {
        try {
            return jwtAppFactory.jweRsaSerializer(this.publicKey);
        }
        catch (CipherException | PublicKeyException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new CompactException(UNABLE_TO_BUILD_COMPACT_JWE, e);
        }
    }

    protected JWE jwe() {
        if (this.publicKey != null) {
            return this.jweForRsa();
        }
        return this.jweForDirect();
    }

    protected JWE jweForDirect() {
        Base64.Decoder decoder = jwtAppFactory.urlDecoder();
        JWE jwe = new JWE();
        Header header = new Header();
        header.setEncryptionAlgorithm(Optional.of(this.encAlg));
        header.setAlgorithm(this.alg);
        header.setKeyId(this.cek.getKeyId());
        jwe.setHeader(header);
        jwe.setPayload(this.payload);
        jwe.setCek(decoder.decode(this.cek.getKey()));
        return jwe;
    }

    protected JWE jweForRsa() {
        JWE jwe = new JWE();
        Header header = new Header();
        header.setKeyId(this.publicKey.getKeyId());
        header.setEncryptionAlgorithm(Optional.of(this.encAlg));
        header.setAlgorithm(this.alg);
        jwe.setHeader(header);
        jwe.setPayload(this.payload);
        return jwe;
    }
}

