/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwe.factory;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.rootservices.jwt.jwe.Transformation;
import org.rootservices.jwt.jwe.factory.exception.CipherException;
import org.rootservices.jwt.jwk.KeyAlgorithm;

public class CipherSymmetricFactory {
    public static final int GCM_TAG_LENGTH = 128;
    public static final int GCM_IV_LENGTH = 96;
    public static final String ALGORITHM_WAS_INVALID = "Algorithm, %s, was invalid";
    public static final String PADDING_WAS_INVALID = "Padding for algorithm, %s, was invalid";
    public static final String KEY_WAS_INVALID_INIT_CIPHER = "Key was invalid when initializing cipher";
    public static final String ALGORITHM_WAS_INVALID_INIT_CIPHER = "Algorithm, %s, was invalid when initializing cipher";
    private static SecureRandom secureRandom = new SecureRandom();

    public Cipher forEncrypt(Transformation transformation, Key key, byte[] aad) throws CipherException {
        byte[] initVector = this.makeInitVector();
        AlgorithmParameterSpec spec = this.makeSpec(transformation, initVector);
        Cipher cipher = this.makeCipher(transformation, key, 1, spec, aad);
        return cipher;
    }

    public Cipher forDecrypt(Transformation transformation, Key key, byte[] initVector, byte[] aad) throws CipherException {
        AlgorithmParameterSpec spec = this.makeSpec(transformation, initVector);
        Cipher cipher = this.makeCipher(transformation, key, 2, spec, aad);
        return cipher;
    }

    public Cipher forDecrypt(Transformation transformation, byte[] cek, byte[] initVector, byte[] aad) throws CipherException {
        SecretKeySpec key = new SecretKeySpec(cek, KeyAlgorithm.AES.getValue());
        Cipher cipher = this.forDecrypt(transformation, key, initVector, aad);
        return cipher;
    }

    public byte[] makeInitVector() {
        byte[] initVector = new byte[96];
        secureRandom.nextBytes(initVector);
        return initVector;
    }

    protected AlgorithmParameterSpec makeSpec(Transformation transformation, byte[] initVector) {
        GCMParameterSpec spec = null;
        if (transformation == Transformation.AES_GCM_NO_PADDING) {
            spec = new GCMParameterSpec(128, initVector);
        }
        return spec;
    }

    protected Cipher makeCipher(Transformation transformation, Key key, int mode, AlgorithmParameterSpec spec, byte[] aad) throws CipherException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(transformation.getValue());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherException(String.format(ALGORITHM_WAS_INVALID, transformation.getValue()), e);
        }
        catch (NoSuchPaddingException e) {
            throw new CipherException(String.format(PADDING_WAS_INVALID, transformation.getValue()), e);
        }
        try {
            cipher.init(mode, key, spec);
        }
        catch (InvalidKeyException e) {
            throw new CipherException(KEY_WAS_INVALID_INIT_CIPHER, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CipherException(String.format(ALGORITHM_WAS_INVALID_INIT_CIPHER, transformation.getValue()), e);
        }
        cipher.updateAAD(aad);
        return cipher;
    }
}

