/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwe.serialization.rsa;

import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.rootservices.jwt.entity.jwk.Key;
import org.rootservices.jwt.entity.jwk.RSAKeyPair;
import org.rootservices.jwt.entity.jwt.header.Header;
import org.rootservices.jwt.jwe.Transformation;
import org.rootservices.jwt.jwe.entity.JWE;
import org.rootservices.jwt.jwe.factory.CipherRSAFactory;
import org.rootservices.jwt.jwe.factory.CipherSymmetricFactory;
import org.rootservices.jwt.jwe.factory.exception.CipherException;
import org.rootservices.jwt.jwe.serialization.JweDeserializer;
import org.rootservices.jwt.jwe.serialization.exception.KeyException;
import org.rootservices.jwt.jwk.PrivateKeyFactory;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.PrivateKeyException;
import org.rootservices.jwt.serialization.Serdes;
import org.rootservices.jwt.serialization.exception.DecryptException;
import org.rootservices.jwt.serialization.exception.JsonException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;

public class JweRsaDeserializer
implements JweDeserializer {
    private Serdes serdes;
    private Base64.Decoder decoder;
    private PrivateKeyFactory privateKeyFactory;
    private CipherRSAFactory cipherRSAFactory;
    private CipherSymmetricFactory cipherSymmetricFactory;

    public JweRsaDeserializer(Serdes serdes, Base64.Decoder decoder, PrivateKeyFactory privateKeyFactory, CipherRSAFactory cipherRSAFactory, CipherSymmetricFactory cipherSymmetricFactory) {
        this.serdes = serdes;
        this.decoder = decoder;
        this.privateKeyFactory = privateKeyFactory;
        this.cipherRSAFactory = cipherRSAFactory;
        this.cipherSymmetricFactory = cipherSymmetricFactory;
    }

    @Override
    public JWE stringToJWE(String compactJWE, Key key) throws JsonToJwtException, DecryptException, CipherException, KeyException {
        byte[] payload;
        byte[] cek;
        RSAPrivateCrtKey jdkKey;
        Header header;
        String[] jweParts = compactJWE.split("\\.");
        byte[] protectedHeader = this.decoder.decode(jweParts[0]);
        byte[] encryptedKey = this.decoder.decode(jweParts[1]);
        byte[] initVector = this.decoder.decode(jweParts[2]);
        byte[] cipherText = this.decoder.decode(jweParts[3]);
        byte[] authenticationTag = this.decoder.decode(jweParts[4]);
        try {
            header = (Header)this.serdes.jsonBytesToObject(protectedHeader, Header.class);
        }
        catch (JsonException e) {
            throw new JsonToJwtException("Compact JWE is invalid", e);
        }
        RSAKeyPair keyPair = (RSAKeyPair)key;
        try {
            jdkKey = this.privateKeyFactory.makePrivateKey(keyPair);
        }
        catch (PrivateKeyException e) {
            throw new KeyException("", e);
        }
        Cipher rsaDecryptCipher = this.cipherRSAFactory.forDecrypt(Transformation.RSA_OAEP, jdkKey);
        try {
            cek = rsaDecryptCipher.doFinal(encryptedKey);
        }
        catch (IllegalBlockSizeException e) {
            throw new DecryptException("Could not Decrypt encrypted key", e);
        }
        catch (BadPaddingException e) {
            throw new DecryptException("Could not Decrypt encrypted key", e);
        }
        byte[] aad = jweParts[0].getBytes(StandardCharsets.US_ASCII);
        Cipher symmetricCipher = this.cipherSymmetricFactory.forDecrypt(Transformation.AES_GCM_NO_PADDING, cek, initVector, aad);
        byte[] cipherTextWithAuthTag = this.cipherTextWithAuthTag(cipherText, authenticationTag);
        try {
            payload = symmetricCipher.doFinal(cipherTextWithAuthTag);
        }
        catch (IllegalBlockSizeException e) {
            throw new DecryptException("Could not decrypt cipher text", e);
        }
        catch (BadPaddingException e) {
            throw new DecryptException("Could not decrypt cipher text", e);
        }
        return new JWE(header, payload, cek, initVector, authenticationTag);
    }
}

