/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwe.serialization.rsa;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.rootservices.jwt.jwe.Transformation;
import org.rootservices.jwt.jwe.entity.JWE;
import org.rootservices.jwt.jwe.factory.CipherSymmetricFactory;
import org.rootservices.jwt.jwe.factory.exception.CipherException;
import org.rootservices.jwt.jwe.serialization.JweSerializer;
import org.rootservices.jwt.jwk.KeyAlgorithm;
import org.rootservices.jwt.jwk.SecretKeyFactory;
import org.rootservices.jwt.jwk.exception.SecretKeyException;
import org.rootservices.jwt.serialization.Serdes;
import org.rootservices.jwt.serialization.exception.EncryptException;
import org.rootservices.jwt.serialization.exception.JsonException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;

public class JweRsaSerializer
implements JweSerializer {
    public static final String COULD_NOT_ENCRYPT_CEK = "Could not encrypt Content Encryption Key";
    public static final String COULD_NOT_ENCRYPT = "Could not encrypt content";
    public static final String HEADER_IS_INVALID = "Header is invalid. Could not serialize to it to JSON";
    public static final String FAILED_TO_CREATE_CONTENT_ENCRYPTION_KEY = "Failed to create Content Encryption Key";
    private Serdes serdes;
    private Base64.Encoder encoder;
    private Cipher RSAEncryptCipher;
    private SecretKeyFactory secretKeyFactory;
    private CipherSymmetricFactory cipherSymmetricFactory;

    public JweRsaSerializer(Serdes serdes, Base64.Encoder encoder, Cipher RSAEncryptCipher, SecretKeyFactory secretKeyFactory, CipherSymmetricFactory cipherSymmetricFactory) {
        this.serdes = serdes;
        this.encoder = encoder;
        this.RSAEncryptCipher = RSAEncryptCipher;
        this.secretKeyFactory = secretKeyFactory;
        this.cipherSymmetricFactory = cipherSymmetricFactory;
    }

    @Override
    public ByteArrayOutputStream JWEToCompact(JWE jwe) throws JsonToJwtException, CipherException, EncryptException {
        byte[] encryptedKey;
        byte[] cipherTextWithAuthTag;
        SecretKey cek;
        byte[] protectedHeader;
        try {
            protectedHeader = this.serdes.objectToByte(jwe.getHeader());
        }
        catch (JsonException e) {
            throw new JsonToJwtException(HEADER_IS_INVALID, e);
        }
        byte[] aad = this.encoder.encode(protectedHeader);
        try {
            cek = this.secretKeyFactory.makeKey(KeyAlgorithm.AES);
        }
        catch (SecretKeyException e) {
            throw new EncryptException(FAILED_TO_CREATE_CONTENT_ENCRYPTION_KEY, e);
        }
        Cipher symmetricCipher = this.symmetricCipherForEncrypt(cek, aad);
        try {
            cipherTextWithAuthTag = symmetricCipher.doFinal(jwe.getPayload());
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptException(COULD_NOT_ENCRYPT, e);
        }
        catch (BadPaddingException e) {
            throw new EncryptException(COULD_NOT_ENCRYPT, e);
        }
        try {
            encryptedKey = this.RSAEncryptCipher.doFinal(cek.getEncoded());
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptException(COULD_NOT_ENCRYPT_CEK, e);
        }
        catch (BadPaddingException e) {
            throw new EncryptException(COULD_NOT_ENCRYPT_CEK, e);
        }
        byte[] initVector = symmetricCipher.getIV();
        byte[] cipherText = this.extractCipherText(cipherTextWithAuthTag);
        byte[] authTag = this.extractAuthTag(cipherTextWithAuthTag);
        ArrayList<byte[]> jweParts = new ArrayList<byte[]>();
        jweParts.add(this.encoder.encode(protectedHeader));
        jweParts.add(this.encoder.encode(encryptedKey));
        jweParts.add(this.encoder.encode(initVector));
        jweParts.add(this.encoder.encode(cipherText));
        jweParts.add(this.encoder.encode(authTag));
        return this.toCompact(jweParts);
    }

    protected Cipher symmetricCipherForEncrypt(SecretKey cek, byte[] aad) throws CipherException {
        Cipher cipher = this.cipherSymmetricFactory.forEncrypt(Transformation.AES_GCM_NO_PADDING, cek, aad);
        return cipher;
    }
}

