/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwk;

import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rootservices.jwt.entity.jwk.RSAKeyPair;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.PrivateKeyException;

public class PrivateKeyFactory {
    private static final Logger LOGGER = LogManager.getLogger(PrivateKeyFactory.class);
    public static final String PRIVATE_KEY_ERROR_MSG = "Could not make RSAPrivateCrtKey";
    private KeyFactory RSAKeyFactory;

    public PrivateKeyFactory(KeyFactory RSAKeyFactory) {
        this.RSAKeyFactory = RSAKeyFactory;
    }

    public RSAPrivateCrtKey makePrivateKey(RSAKeyPair jwk) throws PrivateKeyException {
        RSAPrivateCrtKey privateKey;
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(jwk.getN(), jwk.getE(), jwk.getD(), jwk.getP(), jwk.getQ(), jwk.getDp(), jwk.getDq(), jwk.getQi());
        try {
            privateKey = (RSAPrivateCrtKey)this.RSAKeyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new PrivateKeyException(PRIVATE_KEY_ERROR_MSG, e);
        }
        return privateKey;
    }
}

