/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwk;

import java.security.KeyFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.rootservices.jwt.entity.jwk.RSAPublicKey;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.PublicKeyException;

public class PublicKeyFactory {
    private KeyFactory RSAKeyFactory;

    public PublicKeyFactory(KeyFactory RSAKeyFactory) {
        this.RSAKeyFactory = RSAKeyFactory;
    }

    public java.security.interfaces.RSAPublicKey makePublicKey(RSAPublicKey jwk) throws PublicKeyException {
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(jwk.getN(), jwk.getE());
        java.security.interfaces.RSAPublicKey publicKey = null;
        try {
            publicKey = (java.security.interfaces.RSAPublicKey)this.RSAKeyFactory.generatePublic(rsaPublicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new PublicKeyException("Could not make java.security.interfaces.RSAPublicKey", e);
        }
        return publicKey;
    }
}

