/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jws.signer.factory.rsa;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.rootservices.jwt.entity.jwk.RSAKeyPair;
import org.rootservices.jwt.jws.signer.SignAlgorithm;
import org.rootservices.jwt.jws.signer.factory.exception.InvalidAlgorithmException;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.PrivateKeyException;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.RSAPrivateKeyException;

public class PrivateKeySignatureFactory {
    private KeyFactory RSAKeyFactory;

    public PrivateKeySignatureFactory(KeyFactory RSAKeyFactory) {
        this.RSAKeyFactory = RSAKeyFactory;
    }

    public RSAPrivateCrtKey makePrivateKey(RSAKeyPair jwk) throws PrivateKeyException {
        RSAPrivateCrtKey privateKey;
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(jwk.getN(), jwk.getE(), jwk.getD(), jwk.getP(), jwk.getQ(), jwk.getDp(), jwk.getDq(), jwk.getQi());
        try {
            privateKey = (RSAPrivateCrtKey)this.RSAKeyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new PrivateKeyException("Could not make RSAPrivateCrtKey", e);
        }
        return privateKey;
    }

    public Signature makeSignature(SignAlgorithm alg, RSAKeyPair jwk) throws PrivateKeyException, InvalidAlgorithmException, RSAPrivateKeyException {
        Signature signature;
        RSAPrivateCrtKey privateKey = this.makePrivateKey(jwk);
        try {
            signature = Signature.getInstance(alg.getJdkAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmException("Algorithm is not supported.", e);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException e) {
            throw new RSAPrivateKeyException("Failed adding key to Signature", e);
        }
        return signature;
    }
}

