/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.rootservices.jwt.serialization.exception.JsonException;

public class Serdes {
    public static final String COULD_NOT_CREATE_JSON_FROM = "Could not create json from %s";
    private ObjectMapper objectMapper;

    public Serdes(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] objectToByte(Object object) throws JsonException {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(String.format(COULD_NOT_CREATE_JSON_FROM, object.toString()), e);
        }
    }

    public Object jsonBytesToObject(byte[] json, Class<?> c) throws JsonException {
        Object object;
        try {
            object = this.objectMapper.readValue(json, c);
        }
        catch (IOException e) {
            throw new JsonException("Could not create " + c.toString() + " from json byes, " + json.toString(), e);
        }
        return object;
    }
}

