/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.serialization;

import java.io.ByteArrayOutputStream;
import org.rootservices.jwt.entity.jwt.Claims;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.factory.UnSecureJwtFactory;
import org.rootservices.jwt.serialization.JwtSerde;
import org.rootservices.jwt.serialization.exception.JwtToJsonException;

public class UnSecureJwtSerializer {
    private UnSecureJwtFactory unSecureJwtFactory;
    private JwtSerde jwtSerde;

    public UnSecureJwtSerializer(UnSecureJwtFactory unSecureJwtFactory, JwtSerde jwtSerde) {
        this.unSecureJwtFactory = unSecureJwtFactory;
        this.jwtSerde = jwtSerde;
    }

    public String compactJwtToString(Claims claims) {
        return this.compactJwt(claims).toString();
    }

    public ByteArrayOutputStream compactJwt(Claims claims) {
        JsonWebToken jsonWebToken = this.unSecureJwtFactory.makeJwt(claims);
        ByteArrayOutputStream encodedJwt = null;
        try {
            encodedJwt = this.jwtSerde.compactJwt(jsonWebToken);
        }
        catch (JwtToJsonException e) {
            e.printStackTrace();
        }
        return encodedJwt;
    }
}

