/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwe.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.rootservices.jwt.jwe.entity.JWE;
import org.rootservices.jwt.jwe.factory.exception.CipherException;
import org.rootservices.jwt.serialization.exception.EncryptException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;

public interface JweSerializer {
    public static final byte[] DELIMITER = ".".getBytes();
    public static final String COULD_NOT_COMPACT = "Could not compact";

    public ByteArrayOutputStream JWEToCompact(JWE var1) throws JsonToJwtException, CipherException, EncryptException;

    default public byte[] extractCipherText(byte[] cipherTextWithAuthTag) {
        int tagLength = 16;
        int cipherTextEnd = cipherTextWithAuthTag.length - tagLength;
        byte[] cipherText = new byte[cipherTextEnd];
        System.arraycopy(cipherTextWithAuthTag, 0, cipherText, 0, cipherTextEnd);
        return cipherText;
    }

    default public byte[] extractAuthTag(byte[] cipherTextWithAuthTag) {
        int tagLength = 16;
        int cipherTextEnd = cipherTextWithAuthTag.length - tagLength;
        byte[] authTag = new byte[tagLength];
        System.arraycopy(cipherTextWithAuthTag, cipherTextEnd, authTag, 0, tagLength);
        return authTag;
    }

    default public ByteArrayOutputStream toCompact(List<byte[]> jweParts) throws EncryptException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int i = 0; i < jweParts.size(); ++i) {
            if (jweParts.get(i) != null) {
                try {
                    outputStream.write(jweParts.get(i));
                }
                catch (IOException e) {
                    throw new EncryptException(COULD_NOT_COMPACT, e);
                }
            }
            if (i >= jweParts.size() - 1) continue;
            try {
                outputStream.write(DELIMITER);
                continue;
            }
            catch (IOException e) {
                throw new EncryptException(COULD_NOT_COMPACT, e);
            }
        }
        return outputStream;
    }
}

