/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwe.serialization.direct;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.rootservices.jwt.jwe.Transformation;
import org.rootservices.jwt.jwe.entity.JWE;
import org.rootservices.jwt.jwe.factory.CipherSymmetricFactory;
import org.rootservices.jwt.jwe.factory.exception.CipherException;
import org.rootservices.jwt.jwe.serialization.JweSerializer;
import org.rootservices.jwt.jwk.KeyAlgorithm;
import org.rootservices.jwt.serialization.Serdes;
import org.rootservices.jwt.serialization.exception.EncryptException;
import org.rootservices.jwt.serialization.exception.JsonException;
import org.rootservices.jwt.serialization.exception.JsonToJwtException;

public class JweDirectSerializer
implements JweSerializer {
    public static final String COULD_NOT_ENCRYPT = "Could not encrypt content";
    public static final String HEADER_IS_INVALID = "Header is invalid. Could not serialize to it to JSON";
    private Serdes serdes;
    private Base64.Encoder encoder;
    private CipherSymmetricFactory cipherSymmetricFactory;

    public JweDirectSerializer(Serdes serdes, Base64.Encoder encoder, CipherSymmetricFactory cipherSymmetricFactory) {
        this.serdes = serdes;
        this.encoder = encoder;
        this.cipherSymmetricFactory = cipherSymmetricFactory;
    }

    @Override
    public ByteArrayOutputStream JWEToCompact(JWE jwe) throws JsonToJwtException, CipherException, EncryptException {
        byte[] cipherTextWithAuthTag;
        byte[] protectedHeader;
        try {
            protectedHeader = this.serdes.objectToByte(jwe.getHeader());
        }
        catch (JsonException e) {
            throw new JsonToJwtException(HEADER_IS_INVALID, e);
        }
        byte[] aad = this.encoder.encode(protectedHeader);
        SecretKeySpec key = new SecretKeySpec(jwe.getCek(), KeyAlgorithm.AES.getValue());
        Cipher symmetricCipher = this.cipherSymmetricFactory.forEncrypt(Transformation.AES_GCM_NO_PADDING, key, aad);
        try {
            cipherTextWithAuthTag = symmetricCipher.doFinal(jwe.getPayload());
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptException(COULD_NOT_ENCRYPT, e);
        }
        catch (BadPaddingException e) {
            throw new EncryptException(COULD_NOT_ENCRYPT, e);
        }
        byte[] initVector = symmetricCipher.getIV();
        byte[] cipherText = this.extractCipherText(cipherTextWithAuthTag);
        byte[] authTag = this.extractAuthTag(cipherTextWithAuthTag);
        ArrayList<byte[]> jweParts = new ArrayList<byte[]>();
        jweParts.add(this.encoder.encode(protectedHeader));
        jweParts.add(null);
        jweParts.add(this.encoder.encode(initVector));
        jweParts.add(this.encoder.encode(cipherText));
        jweParts.add(this.encoder.encode(authTag));
        return this.toCompact(jweParts);
    }
}

