/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jwk;

import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.rootservices.jwt.jwk.KeyAlgorithm;
import org.rootservices.jwt.jwk.exception.SecretKeyException;

public class SecretKeyFactory {
    public static final String MESSAGE = "Could not construct key generator";
    private static int keySize = 256;

    public SecretKey makeKey(KeyAlgorithm keyAlgorithm) throws SecretKeyException {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(keyAlgorithm.getValue());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecretKeyException(MESSAGE, e);
        }
        keyGenerator.init(keySize);
        return keyGenerator.generateKey();
    }
}

