/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jws.serialization;

import java.io.ByteArrayOutputStream;
import org.rootservices.jwt.entity.jwt.Claims;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.factory.SecureJwtFactory;
import org.rootservices.jwt.serialization.JwtSerde;
import org.rootservices.jwt.serialization.exception.JwtToJsonException;

public class SecureJwtSerializer {
    private SecureJwtFactory secureJwtFactory;
    private JwtSerde jwtSerde;

    public SecureJwtSerializer(SecureJwtFactory secureJwtFactory, JwtSerde jwtSerde) {
        this.secureJwtFactory = secureJwtFactory;
        this.jwtSerde = jwtSerde;
    }

    public String compactJwtToString(Claims claims) throws JwtToJsonException {
        return this.compactJwt(claims).toString();
    }

    public ByteArrayOutputStream compactJwt(Claims claims) throws JwtToJsonException {
        JsonWebToken jsonWebToken = this.secureJwtFactory.makeJwt(claims);
        ByteArrayOutputStream compactJwt = this.jwtSerde.compactJwt(jsonWebToken);
        return compactJwt;
    }
}

