/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jws.signer;

import java.util.Base64;
import org.rootservices.jwt.entity.jwt.JsonWebToken;
import org.rootservices.jwt.serialization.JwtSerde;
import org.rootservices.jwt.serialization.exception.JwtToJsonException;

public abstract class Signer {
    private JwtSerde jwtSerde;
    private Base64.Encoder encoder;

    public Signer(JwtSerde jwtSerde, Base64.Encoder encoder) {
        this.jwtSerde = jwtSerde;
        this.encoder = encoder;
    }

    public byte[] run(JsonWebToken jwt) throws JwtToJsonException {
        byte[] signInput = this.jwtSerde.makeSignInput(jwt.getHeader(), jwt.getClaims());
        return this.run(signInput);
    }

    protected byte[] encode(byte[] input) {
        return this.encoder.encode(input);
    }

    public abstract byte[] run(byte[] var1);
}

