/*
 * Decompiled with CFR 0.152.
 */
package org.rootservices.jwt.jws.signer.factory;

import java.security.Signature;
import java.util.Base64;
import javax.crypto.Mac;
import org.rootservices.jwt.entity.jwk.Key;
import org.rootservices.jwt.entity.jwk.KeyType;
import org.rootservices.jwt.entity.jwk.RSAKeyPair;
import org.rootservices.jwt.entity.jwk.SymmetricKey;
import org.rootservices.jwt.entity.jwt.header.Algorithm;
import org.rootservices.jwt.jws.signer.MacSigner;
import org.rootservices.jwt.jws.signer.RSASigner;
import org.rootservices.jwt.jws.signer.SignAlgorithm;
import org.rootservices.jwt.jws.signer.Signer;
import org.rootservices.jwt.jws.signer.factory.exception.InvalidAlgorithmException;
import org.rootservices.jwt.jws.signer.factory.exception.InvalidJsonWebKeyException;
import org.rootservices.jwt.jws.signer.factory.hmac.MacFactory;
import org.rootservices.jwt.jws.signer.factory.hmac.exception.SecurityKeyException;
import org.rootservices.jwt.jws.signer.factory.rsa.PrivateKeySignatureFactory;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.PrivateKeyException;
import org.rootservices.jwt.jws.signer.factory.rsa.exception.RSAPrivateKeyException;
import org.rootservices.jwt.serialization.JwtSerde;

public class SignerFactory {
    private MacFactory macFactory;
    private PrivateKeySignatureFactory privateKeySignatureFactory;
    private Base64.Encoder encoder;
    private JwtSerde jwtSerde;

    public SignerFactory(MacFactory macFactory, PrivateKeySignatureFactory privateKeySignatureFactory, JwtSerde jwtSerde, Base64.Encoder encoder) {
        this.macFactory = macFactory;
        this.privateKeySignatureFactory = privateKeySignatureFactory;
        this.jwtSerde = jwtSerde;
        this.encoder = encoder;
    }

    public Signer makeSigner(Algorithm alg, Key jwk) throws InvalidAlgorithmException, InvalidJsonWebKeyException {
        Signer signer = null;
        if (jwk.getKeyType() == KeyType.OCT) {
            signer = this.makeMacSigner(alg, jwk);
        } else if (jwk.getKeyType() == KeyType.RSA) {
            signer = this.makeRSASigner(alg, (RSAKeyPair)jwk);
        }
        return signer;
    }

    public Signer makeMacSigner(Algorithm alg, Key key) throws InvalidAlgorithmException, InvalidJsonWebKeyException {
        Mac mac;
        SignAlgorithm signAlgorithm = SignAlgorithm.valueOf(alg.getValue());
        try {
            mac = this.macFactory.makeMac(signAlgorithm, (SymmetricKey)key);
        }
        catch (SecurityKeyException e) {
            throw new InvalidJsonWebKeyException("", e);
        }
        catch (InvalidAlgorithmException e) {
            throw e;
        }
        return new MacSigner(this.jwtSerde, mac, this.encoder);
    }

    private Signer makeRSASigner(Algorithm alg, RSAKeyPair keyPair) throws InvalidAlgorithmException, InvalidJsonWebKeyException {
        Signature signature;
        SignAlgorithm signAlgorithm = SignAlgorithm.valueOf(alg.getValue());
        try {
            signature = this.privateKeySignatureFactory.makeSignature(signAlgorithm, keyPair);
        }
        catch (PrivateKeyException e) {
            throw new InvalidJsonWebKeyException("", e);
        }
        catch (RSAPrivateKeyException e) {
            throw new InvalidJsonWebKeyException("", e);
        }
        catch (InvalidAlgorithmException e) {
            throw e;
        }
        return new RSASigner(signature, this.jwtSerde, this.encoder);
    }
}

